/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class MinCostDecorator
extends SolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] costs;
    private int[] prevmodel;
    private final IVecInt vars = new VecInt();
    private final IVec<BigInteger> coeffs = new Vec<BigInteger>();

    public MinCostDecorator(ISolver iSolver) {
        super(iSolver);
    }

    @Override
    public int newVar() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int newVar(int n) {
        this.costs = new int[n + 1];
        this.vars.clear();
        this.coeffs.clear();
        for (int i = 1; i <= n; ++i) {
            this.vars.push(i);
            this.coeffs.push(BigInteger.ZERO);
        }
        return super.newVar(n);
    }

    public int costOf(int n) {
        return this.costs[n];
    }

    public void setCost(int n, int n2) {
        this.costs[n] = n2;
        this.coeffs.set(n - 1, BigInteger.valueOf(n2));
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = super.isSatisfiable();
        if (bl) {
            this.prevmodel = super.model();
        }
        return bl;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    @Override
    public Number calculateObjective() {
        return this.calculateDegree(this.prevmodel);
    }

    private int calculateDegree(int[] nArray) {
        int n = 0;
        for (int i = 1; i < this.costs.length; ++i) {
            if (nArray[i - 1] <= 0) continue;
            n += this.costs[i];
        }
        return n;
    }

    @Override
    public void discard() throws ContradictionException {
        super.addPseudoBoolean(this.vars, this.coeffs, false, BigInteger.valueOf(this.calculateDegree(this.prevmodel) - 1));
    }

    @Override
    public int[] model() {
        return this.prevmodel;
    }
}

