/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class MinOneDecorator
extends SolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private int[] prevmodel;
    private int counter;
    private final IVecInt literals = new VecInt();

    public MinOneDecorator(ISolver iSolver) {
        super(iSolver);
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = this.isSatisfiable();
        if (bl) {
            this.prevmodel = super.model();
        }
        return bl;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    @Override
    public Number calculateObjective() {
        this.counter = 0;
        for (int n : this.prevmodel) {
            if (n <= 0) continue;
            ++this.counter;
        }
        return this.counter;
    }

    @Override
    public void discard() throws ContradictionException {
        if (this.literals.isEmpty()) {
            for (int i = 1; i <= this.nVars(); ++i) {
                this.literals.push(i);
            }
        }
        this.addAtMost(this.literals, this.counter - 1);
    }

    @Override
    public int[] model() {
        return this.prevmodel;
    }

    @Override
    public void reset() {
        this.literals.clear();
        super.reset();
    }
}

