/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import java.math.BigInteger;
import org.sat4j.reader.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolverDecorator;

public class PseudoOptDecorator
extends SolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private int[] prevmodel;

    public PseudoOptDecorator(ISolver iSolver) {
        super(iSolver);
    }

    public void setObjectTiveFunction(ObjectiveFunction objectiveFunction) {
        this.objfct = objectiveFunction;
    }

    @Override
    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = super.isSatisfiable();
        if (bl) {
            this.prevmodel = super.model();
        }
        return bl;
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return this.objfct == null;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    @Override
    public Number calculateObjective() {
        return this.objfct.calculateDegree(this.prevmodel);
    }

    @Override
    public void discard() throws ContradictionException {
        super.addPseudoBoolean(this.objfct.getVars(), this.objfct.getCoeffs(), false, this.objfct.calculateDegree(this.prevmodel).subtract(BigInteger.ONE));
    }

    @Override
    public int[] model() {
        return this.prevmodel;
    }
}

