/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.opt.AbstractSelectorVariablesDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class WeightedMaxSatDecorator
extends AbstractSelectorVariablesDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private final IVec<BigInteger> coefs = new Vec<BigInteger>();
    private BigInteger counter;
    private final IVecInt vec = new VecInt();

    public WeightedMaxSatDecorator(ISolver iSolver) {
        super(iSolver);
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        this.coefs.push(BigInteger.valueOf(iVecInt.get(0)));
        iVecInt.set(0, this.nborigvars + ++this.nbnewvar);
        return super.addClause(iVecInt);
    }

    @Override
    public void reset() {
        this.coefs.clear();
        this.vec.clear();
        super.reset();
    }

    @Override
    public boolean hasNoObjectiveFunction() {
        return false;
    }

    @Override
    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Override
    public Number calculateObjective() {
        this.counter = BigInteger.ZERO;
        for (int n : this.prevfullmodel) {
            if (n <= this.nborigvars) continue;
            this.counter = this.counter.add(this.coefs.get(n - this.nborigvars - 1));
        }
        return this.counter;
    }

    @Override
    public void discard() throws ContradictionException {
        if (this.vec.isEmpty()) {
            for (int i = this.nborigvars + 1; i <= this.nVars(); ++i) {
                this.vec.push(i);
            }
        }
        super.addPseudoBoolean(this.vec, this.coefs, false, this.counter.subtract(BigInteger.ONE));
    }
}

