/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.sat4j.core.Vec;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.reader.csp.AllDiff;
import org.sat4j.reader.csp.Clausifiable;
import org.sat4j.reader.csp.Constant;
import org.sat4j.reader.csp.Domain;
import org.sat4j.reader.csp.EnumeratedDomain;
import org.sat4j.reader.csp.Evaluable;
import org.sat4j.reader.csp.Nogoods;
import org.sat4j.reader.csp.Predicate;
import org.sat4j.reader.csp.RangeDomain;
import org.sat4j.reader.csp.Relation;
import org.sat4j.reader.csp.Var;
import org.sat4j.reader.csp.WalshSupports;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

public class CSPReader
extends Reader
implements ICSPCallback {
    private final ISolver solver;
    protected Relation[] relations;
    private int valueindex;
    private int relindex;
    private int[] currentdomain;
    private Domain rangedomain;
    private String currentdomainid;
    private int currentdomainsize;
    private final Map<String, Domain> domainmapping = new HashMap<String, Domain>();
    private final Map<String, Var> varmapping = new LinkedHashMap<String, Var>();
    private final Map<String, Integer> relmapping = new HashMap<String, Integer>();
    private final Map<String, Clausifiable> predmapping = new HashMap<String, Clausifiable>();
    private int nbvarstocreate;
    private int tupleindex;
    private Clausifiable currentclausifiable;
    private Predicate currentpredicate;
    private final IVec<Evaluable> variables = new Vec<Evaluable>();
    private final IVec<Var> scope = new Vec<Var>();
    private int nbvars;
    private int nbconstraints;
    private int currentconstraint;

    public CSPReader(ISolver iSolver) {
        this.solver = iSolver;
        this.predmapping.put("global:allDifferent", new AllDiff());
    }

    @Override
    public final IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(reader));
    }

    private IProblem parseInstance(LineNumberReader lineNumberReader) throws ParseFormatException, ContradictionException {
        this.solver.reset();
        try {
            this.readProblem(lineNumberReader);
            return this.solver;
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseFormatException("integer value expected on line " + lineNumberReader.getLineNumber(), numberFormatException);
        }
    }

    @Override
    public void decode(int[] nArray, PrintWriter printWriter) {
        for (Var var : this.varmapping.values()) {
            printWriter.print(var.findValue(nArray));
            printWriter.print(" ");
        }
    }

    @Override
    public String decode(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Var var : this.varmapping.values()) {
            stringBuilder.append(var.findValue(nArray));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }

    private void readProblem(LineNumberReader lineNumberReader) throws ContradictionException {
        int n;
        int n2;
        int n3;
        int n4;
        Scanner scanner = new Scanner(lineNumberReader);
        this.beginInstance(scanner.nextLine());
        int n5 = scanner.nextInt();
        this.beginDomainsSection(n5);
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = scanner.nextInt();
            assert (n3 == n4);
            int[] nArray = this.readArrayOfInt(scanner);
            this.beginDomain("" + n3, nArray.length);
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.addDomainValue(nArray[n2]);
            }
            this.endDomain();
        }
        this.endDomainsSection();
        n4 = scanner.nextInt();
        this.beginVariablesSection(n4);
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = scanner.nextInt();
            assert (n6 == n3);
            n2 = scanner.nextInt();
            this.addVariable("" + n6, "" + n2);
        }
        this.endVariablesSection();
        n3 = scanner.nextInt();
        this.beginRelationsSection(n3);
        for (n = 0; n < n3; ++n) {
            n2 = scanner.nextInt();
            assert (n2 == n);
            boolean bl = scanner.nextInt() != 1;
            int[] nArray = this.readArrayOfInt(scanner);
            int n7 = scanner.nextInt();
            this.beginRelation("" + n2, nArray.length, n7, !bl);
            for (int i = 0; i < n7; ++i) {
                int[] nArray2 = this.readArrayOfInt(scanner, this.relations[n2].arity());
                this.addRelationTuple(nArray2);
            }
            this.endRelation();
        }
        this.endRelationsSection();
        n = scanner.nextInt();
        this.beginConstraintsSection(n);
        for (n2 = 0; n2 < n; ++n2) {
            int[] nArray = this.readArrayOfInt(scanner);
            this.beginConstraint("" + n2, nArray.length);
            int n8 = scanner.nextInt();
            this.constraintReference("" + n8);
            for (int n9 : nArray) {
                this.addEffectiveParameter("" + n9);
            }
            this.endConstraint();
        }
        this.endConstraintsSection();
        this.endInstance();
    }

    protected void manageAllowedTuples(int n, int n2, int n3) {
        this.relations[n] = new WalshSupports(n2, n3);
    }

    private int[] readArrayOfInt(Scanner scanner) {
        int n = scanner.nextInt();
        return this.readArrayOfInt(scanner, n);
    }

    private int[] readArrayOfInt(Scanner scanner, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = scanner.nextInt();
        }
        return nArray;
    }

    public void beginInstance(String string) {
        System.out.println("c reading problem named " + string);
    }

    public void beginDomainsSection(int n) {
        System.out.print("c reading domains");
    }

    public void beginDomain(String string, int n) {
        this.currentdomainsize = n;
        this.currentdomain = null;
        this.valueindex = -1;
        this.currentdomainid = string;
        this.rangedomain = null;
    }

    public void addDomainValue(int n) {
        if (this.currentdomain == null) {
            this.currentdomain = new int[this.currentdomainsize];
        }
        if (this.rangedomain != null) {
            for (int i = 0; i < this.rangedomain.size(); ++i) {
                this.currentdomain[++this.valueindex] = this.rangedomain.get(i);
            }
            this.rangedomain = null;
        }
        this.currentdomain[++this.valueindex] = n;
    }

    public void addDomainValue(int n, int n2) {
        if (this.currentdomainsize == n2 - n + 1) {
            this.rangedomain = new RangeDomain(n, n2);
        } else {
            if (this.currentdomain == null) {
                this.currentdomain = new int[this.currentdomainsize];
            }
            int n3 = n;
            while (n3 <= n2) {
                this.currentdomain[++this.valueindex] = n3++;
            }
        }
    }

    public void endDomain() {
        assert (this.rangedomain != null || this.valueindex == this.currentdomain.length - 1);
        if (this.rangedomain == null) {
            this.domainmapping.put(this.currentdomainid, new EnumeratedDomain(this.currentdomain));
        } else {
            this.domainmapping.put(this.currentdomainid, this.rangedomain);
        }
    }

    public void endDomainsSection() {
        System.out.println(" done.");
    }

    public void beginVariablesSection(int n) {
        System.out.print("c reading variables");
        this.nbvarstocreate = 0;
        this.nbvars = n;
    }

    public void addVariable(String string, String string2) {
        Domain domain = this.domainmapping.get(string2);
        this.varmapping.put(string, new Var(string, domain, this.nbvarstocreate));
        this.nbvarstocreate += domain.size();
        if (this.isVerbose()) {
            System.out.print("\rc reading variables " + this.varmapping.size() + "/" + this.nbvars);
        }
    }

    public void endVariablesSection() {
        block3: {
            System.out.println("\rc reading variables (" + this.nbvars + ") done.");
            this.solver.newVar(this.nbvarstocreate);
            try {
                for (Var var : this.varmapping.values()) {
                    var.toClause(this.solver);
                }
            }
            catch (ContradictionException contradictionException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void beginRelationsSection(int n) {
        System.out.print("c reading relations");
        this.relations = new Relation[n];
        this.relindex = -1;
    }

    public void beginRelation(String string, int n, int n2, boolean bl) {
        this.relmapping.put(string, ++this.relindex);
        if (this.isVerbose()) {
            System.out.print("\rc reading relations " + this.relindex + "/" + this.relations.length);
        }
        if (bl) {
            this.manageAllowedTuples(this.relindex, n, n2);
        } else {
            this.relations[this.relindex] = new Nogoods(n, n2);
        }
        this.tupleindex = -1;
    }

    public void addRelationTuple(int[] nArray) {
        this.relations[this.relindex].addTuple(++this.tupleindex, nArray);
    }

    public void endRelation() {
    }

    public void endRelationsSection() {
        System.out.println("\rc reading relations (" + this.relations.length + ") done.");
    }

    public void beginPredicatesSection(int n) {
        System.out.print("c reading predicates ");
    }

    public void beginPredicate(String string) {
        this.currentpredicate = new Predicate();
        this.predmapping.put(string, this.currentpredicate);
        if (this.isVerbose()) {
            System.out.print("\rc reading predicate " + this.predmapping.size());
        }
    }

    public void addFormalParameter(String string, String string2) {
        this.currentpredicate.addVariable(string);
    }

    public void predicateExpression(String string) {
        this.currentpredicate.setExpression(string);
    }

    public void endPredicate() {
    }

    public void endPredicatesSection() {
        System.out.println("\rc reading relations (" + this.predmapping.size() + ") done.");
    }

    public void beginConstraintsSection(int n) {
        System.out.print("c reading constraints");
        this.nbconstraints = n;
        this.currentconstraint = 0;
    }

    public void beginConstraint(String string, int n) {
        this.variables.clear();
        this.variables.ensure(n);
        this.scope.clear();
        this.scope.ensure(n);
        if (this.isVerbose()) {
            System.out.print("\rc grounding constraint " + string + "(" + ++this.currentconstraint * 100 / this.nbconstraints + "%)");
        }
    }

    public void constraintReference(String string) {
        Integer n = this.relmapping.get(string);
        this.currentclausifiable = n == null ? this.predmapping.get(string) : this.relations[n];
    }

    public void addVariableToConstraint(String string) {
        this.scope.push(this.varmapping.get(string));
    }

    public void addEffectiveParameter(String string) {
        this.variables.push(this.varmapping.get(string));
    }

    public void addEffectiveParameter(int n) {
        this.variables.push(new Constant(n));
    }

    public void beginParameterList() {
        throw new UnsupportedOperationException("I do not handle parameter list yet!");
    }

    public void addIntegerItem(int n) {
    }

    public void addVariableItem(String string) {
    }

    public void endParamaterList() {
    }

    public void addConstantParameter(String string, int n) {
        throw new UnsupportedOperationException("I do not handle constant parameter yet!");
    }

    public void constraintExpression(String string) {
        throw new UnsupportedOperationException("I do not handle constraint expression yet!");
    }

    public void endConstraint() {
        try {
            this.currentclausifiable.toClause(this.solver, this.scope, this.variables);
        }
        catch (ContradictionException contradictionException) {
            System.err.println("c INSTANCE TRIVIALLY UNSAT");
        }
    }

    public void endConstraintsSection() {
        System.out.println("\rc reading constraints done.");
    }

    public void endInstance() {
    }

    IProblem getProblem() {
        return this.solver;
    }
}

