/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.core.VecInt;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public class ExtendedDimacsReader
extends DimacsReader {
    public static final int FALSE = 1;
    public static final int TRUE = 2;
    public static final int NOT = 3;
    public static final int AND = 4;
    public static final int NAND = 5;
    public static final int OR = 6;
    public static final int NOR = 7;
    public static final int XOR = 8;
    public static final int XNOR = 9;
    public static final int IMPLIES = 10;
    public static final int IFF = 11;
    public static final int IFTHENELSE = 12;
    public static final int ATLEAST = 13;
    public static final int ATMOST = 14;
    public static final int COUNT = 15;
    private static final long serialVersionUID = 1L;

    public ExtendedDimacsReader(ISolver iSolver) {
        super(iSolver);
    }

    @Override
    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p noncnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("noncnf"))) {
            throw new ParseFormatException("problem line expected (p noncnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        assert (n > 0);
        this.solver.newVar(n);
        try {
            this.processClause(new VecInt().push(n));
        }
        catch (ContradictionException contradictionException) {
            assert (false);
            System.err.println("Contradiction when asserting root variable?");
        }
        this.disableNumberOfConstraintCheck();
    }

    @Override
    protected boolean handleConstr(String string, IVecInt iVecInt) throws ContradictionException {
        boolean bl = true;
        assert (iVecInt.size() == 0);
        Scanner scanner = new Scanner(string);
        block10: while (scanner.hasNext()) {
            int n;
            int n2;
            int n3 = scanner.nextInt();
            assert (n3 > 0);
            int n4 = scanner.nextInt();
            assert (n4 != 0);
            assert (n4 == -1 || n3 >= 13);
            int n5 = -1;
            for (n2 = 0; n2 < n4; ++n2) {
                n5 = scanner.nextInt();
            }
            n2 = scanner.nextInt();
            while ((n = scanner.nextInt()) != 0) {
                iVecInt.push(n);
            }
            assert (iVecInt.size() == n5);
            switch (n3) {
                case 1: {
                    this.gateFalse(n2, iVecInt);
                    continue block10;
                }
                case 2: {
                    this.gateTrue(n2, iVecInt);
                    continue block10;
                }
                case 6: {
                    this.or(n2, iVecInt);
                    continue block10;
                }
                case 3: {
                    this.not(n2, iVecInt);
                    continue block10;
                }
                case 4: {
                    this.and(n2, iVecInt);
                    continue block10;
                }
                case 8: {
                    this.xor(n2, iVecInt);
                    continue block10;
                }
                case 11: {
                    this.iff(n2, iVecInt);
                    continue block10;
                }
                case 12: {
                    this.ite(n2, iVecInt);
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Gate type " + n3 + " not handled yet");
        }
        iVecInt.clear();
        return bl;
    }

    private void gateFalse(int n, IVecInt iVecInt) throws ContradictionException {
        assert (iVecInt.size() == 0);
        VecInt vecInt = new VecInt(1);
        vecInt.push(-n);
        this.processClause(vecInt);
    }

    private void gateTrue(int n, IVecInt iVecInt) throws ContradictionException {
        assert (iVecInt.size() == 0);
        VecInt vecInt = new VecInt(1);
        vecInt.push(n);
        this.processClause(vecInt);
    }

    private void ite(int n, IVecInt iVecInt) throws ContradictionException {
        assert (iVecInt.size() == 3);
        VecInt vecInt = new VecInt(2);
        vecInt.push(-n).push(-iVecInt.get(0)).push(iVecInt.get(1));
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-n).push(iVecInt.get(0)).push(iVecInt.get(2));
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-iVecInt.get(0)).push(-iVecInt.get(1)).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(iVecInt.get(0)).push(-iVecInt.get(2)).push(n);
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(-iVecInt.get(1)).push(-iVecInt.get(2)).push(n);
        this.processClause(vecInt);
    }

    private void and(int n, IVecInt iVecInt) throws ContradictionException {
        int n2;
        VecInt vecInt = new VecInt(iVecInt.size() + 1);
        vecInt.push(n);
        for (n2 = 0; n2 < iVecInt.size(); ++n2) {
            vecInt.push(-iVecInt.get(n2));
        }
        this.processClause(vecInt);
        vecInt.clear();
        for (n2 = 0; n2 < iVecInt.size(); ++n2) {
            vecInt.clear();
            vecInt.push(-n);
            vecInt.push(iVecInt.get(n2));
            this.processClause(vecInt);
        }
    }

    private void or(int n, IVecInt iVecInt) throws ContradictionException {
        VecInt vecInt = new VecInt(iVecInt.size() + 1);
        iVecInt.copyTo(vecInt);
        vecInt.push(-n);
        this.processClause(vecInt);
        vecInt.clear();
        for (int i = 0; i < iVecInt.size(); ++i) {
            vecInt.clear();
            vecInt.push(n);
            vecInt.push(-iVecInt.get(i));
            this.processClause(vecInt);
        }
    }

    private void processClause(IVecInt iVecInt) throws ContradictionException {
        this.solver.addClause(iVecInt);
    }

    private void not(int n, IVecInt iVecInt) throws ContradictionException {
        assert (iVecInt.size() == 1);
        VecInt vecInt = new VecInt(2);
        vecInt.push(-n).push(-iVecInt.get(0));
        this.processClause(vecInt);
        vecInt.clear();
        vecInt.push(n).push(iVecInt.get(0));
        this.processClause(vecInt);
    }

    void xor(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(-n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        this.xor2Clause(nArray, 0, false);
    }

    void iff(int n, IVecInt iVecInt) throws ContradictionException {
        iVecInt.push(n);
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        this.iff2Clause(nArray, 0, false);
    }

    void xor2Clause(int[] nArray, int n, boolean bl) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length);
            for (int i = 0; i < nArray.length - 1; ++i) {
                vecInt.push(nArray[i]);
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            this.processClause(vecInt);
            return;
        }
        if (bl) {
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true);
        } else {
            this.xor2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.xor2Clause(nArray, n + 1, true);
            nArray[n] = -nArray[n];
        }
    }

    void iff2Clause(int[] nArray, int n, boolean bl) throws ContradictionException {
        if (n == nArray.length - 1) {
            VecInt vecInt = new VecInt(nArray.length);
            for (int i = 0; i < nArray.length - 1; ++i) {
                vecInt.push(nArray[i]);
            }
            vecInt.push(nArray[nArray.length - 1] * (bl ? -1 : 1));
            this.processClause(vecInt);
            return;
        }
        if (bl) {
            this.iff2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true);
            nArray[n] = -nArray[n];
        } else {
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, false);
            nArray[n] = -nArray[n];
            this.iff2Clause(nArray, n + 1, true);
        }
    }
}

