/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import org.sat4j.reader.AAGReader;
import org.sat4j.reader.AIGReader;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.CSPReader;
import org.sat4j.reader.CSPSupportReader;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ExtendedDimacsReader;
import org.sat4j.reader.GoodOPBReader;
import org.sat4j.reader.LecteurDimacs;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class InstanceReader
extends Reader {
    private AAGReader aag;
    private AIGReader aig;
    private DimacsReader ezdimacs;
    private LecteurDimacs dimacs;
    private GoodOPBReader opb;
    private ExtendedDimacsReader edimacs;
    private CSPReader csp;
    private CSPReader csp2;
    private CSPReader csp3;
    private XMLCSPReader xmlcsp;
    private Reader reader = null;
    private final ISolver solver;

    public InstanceReader(ISolver iSolver) {
        this.solver = iSolver;
    }

    private Reader getDefaultSATReader() {
        if (this.dimacs == null) {
            this.dimacs = new LecteurDimacs(this.solver);
        }
        return this.dimacs;
    }

    private Reader getEZSATReader() {
        if (this.ezdimacs == null) {
            this.ezdimacs = new DimacsReader(this.solver);
        }
        return this.ezdimacs;
    }

    private Reader getDefaultOPBReader() {
        if (this.opb == null) {
            this.opb = new GoodOPBReader(this.solver);
        }
        return this.opb;
    }

    private Reader getDefaultExtendedDimacsReader() {
        if (this.edimacs == null) {
            this.edimacs = new ExtendedDimacsReader(this.solver);
        }
        return this.edimacs;
    }

    private Reader getCSPReader1() {
        if (this.csp == null) {
            this.csp = new CSPReader(this.solver);
        }
        return this.csp;
    }

    private Reader getCSPReader2() {
        if (this.csp2 == null) {
            this.csp2 = new CSPSupportReader(this.solver);
        }
        return this.csp2;
    }

    private Reader getCSPReader3() {
        if (this.csp3 == null) {
            this.csp3 = new CSPExtSupportReader(this.solver);
        }
        return this.csp3;
    }

    private Reader getXMLCSPReader() {
        if (this.xmlcsp == null) {
            this.xmlcsp = new XMLCSPReader(this.solver);
        }
        return this.xmlcsp;
    }

    private Reader getAIGReader() {
        if (this.aig == null) {
            this.aig = new AIGReader(this.solver);
        }
        return this.aig;
    }

    private Reader getAAGReader() {
        if (this.aag == null) {
            this.aag = new AAGReader(this.solver);
        }
        return this.aag;
    }

    @Override
    public IProblem parseInstance(String string) throws FileNotFoundException, ParseFormatException, IOException, ContradictionException {
        boolean bl = false;
        String string2 = "";
        String string3 = "";
        if (string.startsWith("http://")) {
            bl = true;
            string2 = string;
            string = string.substring(string.lastIndexOf(47), string.length() - 1);
        }
        if (string.indexOf(58) != -1) {
            String[] stringArray = string.split(":");
            string = stringArray[1];
            string3 = stringArray[0].toUpperCase();
        }
        String string4 = string.endsWith(".gz") ? string.substring(0, string.lastIndexOf(46)) : string;
        this.reader = "EZCNF".equals(string3) ? this.getEZSATReader() : ("CSP".equals(string3) ? this.getCSPReader1() : ("CSP3".equals(string3) ? this.getCSPReader3() : (string4.endsWith(".txt") || "CSP2".equals(string3) ? this.getCSPReader2() : (string4.endsWith(".opb") || "PB".equals(string3) ? this.getDefaultOPBReader() : (string4.endsWith(".edimacs") || string4.endsWith(".ncnf") || "EDIMACS".equals(string3) ? this.getDefaultExtendedDimacsReader() : (string4.endsWith(".xml") ? this.getXMLCSPReader() : (string4.endsWith(".aag") ? this.getAAGReader() : (string4.endsWith(".aig") ? this.getAIGReader() : this.getDefaultSATReader()))))))));
        if (bl) {
            return this.reader.parseInstance(new URL(string2).openStream());
        }
        return this.reader.parseInstance(string);
    }

    @Override
    public String decode(int[] nArray) {
        return this.reader.decode(nArray);
    }

    @Override
    public void decode(int[] nArray, PrintWriter printWriter) {
        this.reader.decode(nArray, printWriter);
    }

    @Override
    public IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        throw new UnsupportedOperationException();
    }
}

