/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;

public class LecteurDimacs
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TAILLE_BUF = 16384;
    private final ISolver s;
    private transient BufferedInputStream in;
    private int nbLit = 0;
    private int nbClauses = 0;
    private static final char EOF = '\uffff';

    public LecteurDimacs(ISolver iSolver) {
        this.s = iSolver;
    }

    @Override
    public final IProblem parseInstance(InputStream inputStream) throws ParseFormatException, ContradictionException, IOException {
        this.in = new BufferedInputStream(inputStream, 16384);
        this.s.reset();
        char c = this.passerCommentaire();
        if (this.nbLit == 0) {
            throw new IOException("DIMACS non valide (nombre de Literaux non valide)");
        }
        this.s.newVar(this.nbLit);
        this.s.setExpectedNumberOfClauses(this.nbClauses);
        c = this.passerEspaces();
        if (c == '\uffff') {
            throw new IOException("DIMACS non valide (o? sont les clauses ?)");
        }
        this.ajouterClauses(c);
        inputStream.close();
        return this.s;
    }

    @Override
    public IProblem parseInstance(java.io.Reader reader) throws IOException, ContradictionException {
        throw new UnsupportedOperationException();
    }

    private char passerCommentaire() throws IOException {
        char c;
        do {
            if ((c = this.passerEspaces()) != 'p') continue;
            c = this.lectureNombreLiteraux();
        } while ((c == 'c' || c == 'p') && (c = this.nextLine()) != '\uffff');
        return c;
    }

    private char lectureNombreLiteraux() throws IOException {
        char c = this.nextChiffre();
        if (c != '\uffff') {
            this.nbLit = c - 48;
            while ((c = (char)this.in.read()) >= '0' && c <= '9') {
                this.nbLit = 10 * this.nbLit + (c - 48);
            }
            c = this.nextChiffre();
            this.nbClauses = c - 48;
            while ((c = (char)this.in.read()) >= '0' && c <= '9') {
                this.nbClauses = 10 * this.nbClauses + (c - 48);
            }
            if (c != '\n' && c != '\uffff') {
                this.nextLine();
            }
        }
        return c;
    }

    private void ajouterClauses(char c) throws IOException, ContradictionException {
        VecInt vecInt = new VecInt();
        int n = 0;
        boolean bl = false;
        do {
            if (c == '-') {
                bl = true;
                c = (char)this.in.read();
            } else if (c == '+') {
                c = (char)this.in.read();
            } else {
                if (c < '0' || c > '9') break;
                n = c - 48;
                c = (char)this.in.read();
            }
            while (c >= '0' && c <= '9') {
                n = n * 10 + c - 48;
                c = (char)this.in.read();
            }
            if (n == 0) {
                this.s.addClause(vecInt);
                vecInt.clear();
            } else {
                vecInt.push(bl ? -n : n);
                bl = false;
                n = 0;
            }
            if (c == '\uffff') continue;
            c = this.passerEspaces();
        } while (c != '\uffff');
    }

    private char passerEspaces() throws IOException {
        char c;
        while ((c = (char)this.in.read()) == ' ' || c == '\n') {
        }
        return c;
    }

    private char nextLine() throws IOException {
        char c;
        while ((c = (char)this.in.read()) != '\n' && c != '\uffff') {
        }
        return c;
    }

    private char nextChiffre() throws IOException {
        char c;
        while ((c = (char)this.in.read()) < '0' || c > '9' && c != '\uffff') {
        }
        return c;
    }

    @Override
    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(" ");
        }
        stringBuffer.append("0");
        return stringBuffer.toString();
    }

    @Override
    public void decode(int[] nArray, PrintWriter printWriter) {
        for (int i = 0; i < nArray.length; ++i) {
            printWriter.print(nArray[i]);
            printWriter.print(" ");
        }
        printWriter.print("0");
    }
}

