/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.reader.csp.Encoding;
import org.sat4j.reader.csp.Evaluable;
import org.sat4j.reader.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class BinarySupportEncoding
implements Encoding {
    private final Map<Integer, IVecInt> supportsa = new HashMap<Integer, IVecInt>();
    private final Map<Integer, IVecInt> supportsb = new HashMap<Integer, IVecInt>();
    private static final Encoding instance = new BinarySupportEncoding();

    private BinarySupportEncoding() {
    }

    public static Encoding instance() {
        return instance;
    }

    @Override
    public void onFinish(ISolver iSolver, IVec<Var> iVec) throws ContradictionException {
        this.generateClauses(iVec.get(0), this.supportsa, iSolver);
        this.generateClauses(iVec.get(1), this.supportsb, iSolver);
    }

    @Override
    public void onInit(ISolver iSolver, IVec<Var> iVec) {
        this.supportsa.clear();
        this.supportsb.clear();
    }

    @Override
    public void onNogood(ISolver iSolver, IVec<Var> iVec, Map<Evaluable, Integer> map) throws ContradictionException {
    }

    @Override
    public void onSupport(ISolver iSolver, IVec<Var> iVec, Map<Evaluable, Integer> map) throws ContradictionException {
        Var var = iVec.get(0);
        int n = map.get(var);
        Var var2 = iVec.get(1);
        int n2 = map.get(var2);
        this.addSupport(n, var2, n2, this.supportsa);
        this.addSupport(n2, var, n, this.supportsb);
    }

    private void addSupport(int n, Evaluable evaluable, int n2, Map<Integer, IVecInt> map) {
        IVecInt iVecInt = map.get(n);
        if (iVecInt == null) {
            iVecInt = new VecInt();
            map.put(n, iVecInt);
        }
        iVecInt.push(evaluable.translate(n2));
    }

    private void generateClauses(Evaluable evaluable, Map<Integer, IVecInt> map, ISolver iSolver) throws ContradictionException {
        VecInt vecInt = new VecInt();
        Iterator iterator = evaluable.domain().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            vecInt.clear();
            IVecInt iVecInt = map.get(n);
            vecInt.push(-evaluable.translate(n));
            if (iVecInt != null) {
                Iterator iterator2 = iVecInt.iterator();
                while (iterator2.hasNext()) {
                    int n2 = (Integer)iterator2.next();
                    vecInt.push(n2);
                }
            }
            iSolver.addClause(vecInt);
        }
    }
}

