/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sat4j.reader.csp.Domain;

public class EnumeratedDomain
implements Domain {
    private final int[] values;

    public EnumeratedDomain(int[] nArray) {
        this.values = nArray;
    }

    @Override
    public int get(int n) {
        return this.values[n];
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < EnumeratedDomain.this.values.length;
            }

            @Override
            public Integer next() {
                if (this.i == EnumeratedDomain.this.values.length) {
                    throw new NoSuchElementException();
                }
                return EnumeratedDomain.this.values[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int pos(int n) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != n) continue;
            return i;
        }
        return -1;
    }
}

