/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.sat4j.core.VecInt;
import org.sat4j.reader.csp.Encoding;
import org.sat4j.reader.csp.Evaluable;
import org.sat4j.reader.csp.Var;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

public class GeneralizedSupportEncoding
implements Encoding {
    private final Map<Set<Integer>, IVecInt> supports = new HashMap<Set<Integer>, IVecInt>();
    private static final Encoding instance = new GeneralizedSupportEncoding();

    private GeneralizedSupportEncoding() {
    }

    public static Encoding instance() {
        return instance;
    }

    @Override
    public void onFinish(ISolver iSolver, IVec<Var> iVec) throws ContradictionException {
    }

    @Override
    public void onInit(ISolver iSolver, IVec<Var> iVec) {
        this.supports.clear();
        int[] nArray = new int[iVec.size()];
        this.fill(0, iVec, nArray, this.supports);
    }

    @Override
    public void onNogood(ISolver iSolver, IVec<Var> iVec, Map<Evaluable, Integer> map) throws ContradictionException {
    }

    @Override
    public void onSupport(ISolver iSolver, IVec<Var> iVec, Map<Evaluable, Integer> map) throws ContradictionException {
        for (int i = 0; i < iVec.size(); ++i) {
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            Var var = iVec.get(i);
            for (int j = 0; j < iVec.size(); ++j) {
                if (i == j) continue;
                treeSet.add(iVec.get(j).translate(map.get(var)));
            }
            IVecInt iVecInt = this.supports.get(treeSet);
            assert (iVecInt != null);
            iVecInt.push(var.translate(map.get(var)));
        }
    }

    private void fill(int n, IVec<Var> iVec, int[] nArray, Map<Set<Integer>, IVecInt> map) {
        if (n == iVec.size()) {
            for (int i = 0; i < nArray.length; ++i) {
                TreeSet<Integer> treeSet = new TreeSet<Integer>();
                for (int j = 0; j < nArray.length; ++j) {
                    if (j == i) continue;
                    treeSet.add(iVec.get(j).translate(nArray[j]));
                }
                map.put(treeSet, new VecInt());
            }
        } else {
            Iterator iterator = iVec.get(n).domain().iterator();
            while (iterator.hasNext()) {
                int n2;
                nArray[n] = n2 = ((Integer)iterator.next()).intValue();
                this.fill(n + 1, iVec, nArray, map);
            }
        }
    }
}

