/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader.csp;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.sat4j.reader.csp.Domain;

public class RangeDomain
implements Domain {
    private final int begin;
    private final int end;
    private final int size;

    public RangeDomain(int n, int n2) {
        this.begin = n;
        this.end = n2;
        this.size = n2 - n + 1;
    }

    @Override
    public int get(int n) {
        assert (n >= 0);
        return this.begin + n;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int i;
            {
                this.i = RangeDomain.this.begin;
            }

            @Override
            public boolean hasNext() {
                return this.i <= RangeDomain.this.end;
            }

            @Override
            public Integer next() {
                if (this.i > RangeDomain.this.end) {
                    throw new NoSuchElementException();
                }
                return this.i++;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int pos(int n) {
        return n - this.begin;
    }
}

