/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.Serializable;
import org.sat4j.specs.ContradictionException;

public class DimacsArrayToDimacsConverter
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int clauses;
    protected StringBuilder dimacs;
    private final int bufSize;

    public DimacsArrayToDimacsConverter(int n) {
        this.bufSize = n;
    }

    protected boolean handleConstr(int n, int n2, int[] nArray) throws ContradictionException {
        for (int n3 : nArray) {
            this.dimacs.append(n3);
            this.dimacs.append(" ");
        }
        this.dimacs.append("0\n");
        ++this.clauses;
        return true;
    }

    public String parseInstance(int[] nArray, int[] nArray2, int[][] nArray3, int n) throws ContradictionException {
        this.init();
        this.dimacs.append(n);
        this.dimacs.append(" ");
        int n2 = 7 + Integer.toString(n).length();
        this.dimacs.append("                    ");
        this.dimacs.append("\n");
        for (int i = 0; i < nArray2.length; ++i) {
            this.handleConstr(nArray[i], nArray2[i], nArray3[i]);
        }
        String string = Integer.toString(this.clauses);
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            this.dimacs.setCharAt(n2 + i, string.charAt(i));
        }
        String string2 = this.dimacs.toString();
        this.dimacs = null;
        return string2;
    }

    protected void init() {
        this.dimacs = new StringBuilder(this.bufSize);
        this.dimacs.append("p cnf ");
        this.clauses = 0;
    }

    public String decode(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuilder.append(nArray[i]);
            stringBuilder.append(" ");
        }
        stringBuilder.append("0");
        return stringBuilder.toString();
    }
}

