/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.minisat.orders.ValuedLit;
import org.sat4j.minisat.orders.VarOrder;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWOrder
extends VarOrder<ILits23> {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$minisat$orders$JWOrder;

    private int computeWeight(int n) {
        int n2 = LiteralsUtils.posLit(n);
        int n3 = ((ILits23)this.lits).nBinaryClauses(n2);
        int n4 = ((ILits23)this.lits).nBinaryClauses(LiteralsUtils.neg(n2));
        int n5 = ((ILits23)this.lits).nTernaryClauses(n2);
        int n6 = ((ILits23)this.lits).nTernaryClauses(LiteralsUtils.neg(n2));
        long l = (n3 * n4 * 100 + n3 + n4) * 5 + n5 * n6 * 10 + n5 + n6;
        if (!$assertionsDisabled && l > Integer.MAX_VALUE) {
            throw new AssertionError();
        }
        if (l == 0L) {
            int n7 = ((ILits23)this.lits).watches(n2).size();
            int n8 = ((ILits23)this.lits).watches(LiteralsUtils.neg(n2)).size();
            l = n7 + n8;
        }
        return (int)l;
    }

    @Override
    public void init() {
        ValuedLit valuedLit;
        int n;
        super.init();
        ArrayList<ValuedLit> arrayList = new ArrayList<ValuedLit>(this.order.length);
        for (n = 1; n < this.order.length; ++n) {
            valuedLit = new ValuedLit(this.order[n], this.computeWeight(this.order[n] >> 1));
            arrayList.add(valuedLit);
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            valuedLit = (ValuedLit)arrayList.get(n);
            this.order[n + 1] = valuedLit.id;
            int n2 = LiteralsUtils.var(valuedLit.id);
            this.varpos[n2] = n + 1;
            this.activity[n2] = valuedLit.count;
        }
        this.lastVar = 1;
    }

    @Override
    protected void updateActivity(int n) {
        this.activity[n] = this.computeWeight(n);
    }

    @Override
    public String toString() {
        return "Jeroslow-Wang static like heuristics updated when new clauses are learnt";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$minisat$orders$JWOrder == null ? (class$org$sat4j$minisat$orders$JWOrder = JWOrder.class$("org.sat4j.minisat.orders.JWOrder")) : class$org$sat4j$minisat$orders$JWOrder).desiredAssertionStatus();
    }
}

