/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;

public class LubyRestarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private int factor;
    private int count;
    static final /* synthetic */ boolean $assertionsDisabled;

    static final long luby_super(long l) {
        long l2;
        if (!$assertionsDisabled && l <= 0L) {
            throw new AssertionError();
        }
        long l3 = 1L;
        for (l2 = 2L; l2 < l + 1L; l2 *= 2L) {
            ++l3;
        }
        if (l2 == l + 1L) {
            return l2 / 2L;
        }
        return LubyRestarts.luby_super(l - l2 / 2L + 1L);
    }

    public LubyRestarts() {
        this.setFactor(32);
    }

    public void setFactor(int n) {
        this.factor = n;
    }

    public int getFactor() {
        return this.factor;
    }

    public void init(SearchParams searchParams) {
        this.count = 1;
    }

    public long nextRestartNumberOfConflict() {
        return LubyRestarts.luby_super(this.count) * (long)this.factor;
    }

    public void onRestart() {
        ++this.count;
    }

    public String toString() {
        return "luby style (SATZ_rand, TiniSAT) restarts strategy with factor " + this.factor;
    }

    static {
        $assertionsDisabled = !LubyRestarts.class.desiredAssertionStatus();
    }
}

