/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.TimeoutException;

public class PseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private ObjectiveFunction objfct;
    private int[] prevmodel;

    public PseudoOptDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public void setObjectTiveFunction(ObjectiveFunction objectiveFunction) {
        this.objfct = objectiveFunction;
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = super.isSatisfiable(true);
        if (bl) {
            this.prevmodel = super.model();
        }
        return bl;
    }

    public boolean hasNoObjectiveFunction() {
        return this.objfct == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return true;
    }

    public Number calculateObjective() {
        return this.objfct.calculateDegree(this.prevmodel);
    }

    public void discard() throws ContradictionException {
        super.addPseudoBoolean(this.objfct.getVars(), this.objfct.getCoeffs(), false, this.objfct.calculateDegree(this.prevmodel).subtract(BigInteger.ONE));
    }

    public int[] model() {
        return this.prevmodel;
    }
}

