/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.sat4j.core.Vec;
import org.sat4j.csp.Clausifiable;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.csp.encodings.BinarySupportEncoding;
import org.sat4j.csp.encodings.DirectEncoding;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Predicate
implements Clausifiable {
    private String expr;
    private Encoding encoding;
    private final IVec<String> variables = new Vec<String>();
    private static Context cx;
    private static Scriptable scope;
    private final Map<Evaluable, Integer> valuemapping = new HashMap<Evaluable, Integer>();
    private Script myscript;
    static /* synthetic */ Class class$org$sat4j$csp$Predicate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setExpression(String string) {
        this.expr = string;
    }

    public void addVariable(String string) {
        this.variables.push(string);
    }

    private boolean evaluate(int[] nArray) {
        if (!$assertionsDisabled && nArray.length != this.variables.size()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.variables.size(); ++i) {
            scope.put(this.variables.get(i), scope, (Object)new Integer(nArray[i]));
        }
        Object object = this.myscript.exec(cx, scope);
        return Context.toBoolean(object);
    }

    @Override
    public void toClause(ISolver iSolver, IVec<Var> iVec, IVec<Evaluable> iVec2) throws ContradictionException {
        if (this.myscript == null) {
            this.myscript = cx.compileString(this.expr, "rhino.log", 1, null);
        }
        this.encoding = iVec.size() == 2 ? BinarySupportEncoding.instance() : DirectEncoding.instance();
        this.encoding.onInit(iSolver, iVec);
        int[] nArray = new int[iVec2.size()];
        this.valuemapping.clear();
        this.find(nArray, 0, iVec, iVec2, iSolver);
        this.encoding.onFinish(iSolver, iVec);
    }

    private void find(int[] nArray, int n, IVec<Var> iVec, IVec<Evaluable> iVec2, ISolver iSolver) throws ContradictionException {
        if (this.valuemapping.size() == iVec.size()) {
            for (int i = 0; i < nArray.length; ++i) {
                Evaluable evaluable = iVec2.get(i);
                Integer n2 = this.valuemapping.get(evaluable);
                nArray[i] = n2 == null ? evaluable.domain().get(0) : n2.intValue();
            }
            if (this.evaluate(nArray)) {
                this.encoding.onSupport(iSolver, iVec, this.valuemapping);
            } else {
                this.encoding.onNogood(iSolver, iVec, this.valuemapping);
            }
        } else {
            Var var = iVec.get(n);
            Domain domain = var.domain();
            for (int i = 0; i < domain.size(); ++i) {
                this.valuemapping.put(var, new Integer(domain.get(i)));
                this.find(nArray, n + 1, iVec, iVec2, iSolver);
            }
            this.valuemapping.remove(var);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$csp$Predicate == null ? (class$org$sat4j$csp$Predicate = Predicate.class$("org.sat4j.csp.Predicate")) : class$org$sat4j$csp$Predicate).desiredAssertionStatus();
        cx = Context.enter();
        scope = cx.initStandardObjects();
        try {
            URL uRL = (class$org$sat4j$csp$Predicate == null ? (class$org$sat4j$csp$Predicate = Predicate.class$("org.sat4j.csp.Predicate")) : class$org$sat4j$csp$Predicate).getResource("predefinedfunctions.js");
            cx.evaluateReader(scope, new InputStreamReader(uRL.openStream()), "predefinedfunctions.js", 1, null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

