/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.constraints;

import java.util.HashMap;
import java.util.Map;
import org.sat4j.csp.Domain;
import org.sat4j.csp.Encoding;
import org.sat4j.csp.Evaluable;
import org.sat4j.csp.Var;
import org.sat4j.csp.constraints.Relation;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Supports
implements Relation {
    private Encoding encoding;
    private final int arity;
    private int[][] tuples;
    private int lastmatch;
    private Map<Evaluable, Integer> mtuple;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$csp$constraints$Supports;

    public Supports(int n, int n2) {
        this.arity = n;
        this.tuples = new int[n2][];
    }

    @Override
    public void addTuple(int n, int[] nArray) {
        this.tuples[n] = nArray;
    }

    @Override
    public int arity() {
        return this.arity;
    }

    @Override
    public void toClause(ISolver iSolver, IVec<Var> iVec, IVec<Evaluable> iVec2) throws ContradictionException {
        if (!$assertionsDisabled && iVec2.size() != 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && iVec.size() != this.arity) {
            throw new AssertionError();
        }
        int[] nArray = new int[iVec.size()];
        this.mtuple = new HashMap<Evaluable, Integer>();
        this.lastmatch = -1;
        this.encoding = this.chooseEncoding(iVec);
        this.encoding.onInit(iSolver, iVec);
        this.find(nArray, 0, iVec, iSolver);
        this.encoding.onFinish(iSolver, iVec);
    }

    protected abstract Encoding chooseEncoding(IVec<Var> var1);

    private void find(int[] nArray, int n, IVec<Var> iVec, ISolver iSolver) throws ContradictionException {
        if (n == iVec.size()) {
            if (!$assertionsDisabled && this.mtuple.size() != n) {
                throw new AssertionError();
            }
            if (this.notPresent(nArray)) {
                this.encoding.onNogood(iSolver, iVec, this.mtuple);
            } else {
                this.encoding.onSupport(iSolver, iVec, this.mtuple);
            }
        } else {
            Domain domain = iVec.get(n).domain();
            for (int i = 0; i < domain.size(); ++i) {
                nArray[n] = domain.get(i);
                this.mtuple.put(iVec.get(n), new Integer(nArray[n]));
                this.find(nArray, n + 1, iVec, iSolver);
            }
            this.mtuple.remove(iVec.get(n));
        }
    }

    private boolean notPresent(int[] nArray) {
        int n = this.lastmatch + 1;
        int n2 = 0;
        int[][] nArray2 = this.tuples;
        while (n < nArray2.length && n2 < nArray.length) {
            int n3 = nArray2[n][n2];
            int n4 = nArray[n2];
            if (n3 < n4) {
                ++n;
                n2 = 0;
                continue;
            }
            if (n3 > n4) {
                return true;
            }
            ++n2;
        }
        if (n2 == nArray.length) {
            this.lastmatch = n;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$csp$constraints$Supports == null ? (class$org$sat4j$csp$constraints$Supports = Supports.class$("org.sat4j.csp.constraints.Supports")) : class$org$sat4j$csp$constraints$Supports).desiredAssertionStatus();
    }
}

