/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.maxsat;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Solver;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.pb.orders.VarOrderHeapObjective;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class WeightedMaxSatDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    protected int nborigvars;
    private int nbexpectedclauses;
    private long falsifiedWeight;
    protected int nbnewvar;
    protected int[] prevfullmodel;
    protected int top = -1;
    private int counter;
    private final IVecInt lits = new VecInt();
    private final IVec<BigInteger> coefs = new Vec();
    private final ObjectiveFunction obj = new ObjectiveFunction(this.lits, this.coefs);
    static final /* synthetic */ boolean $assertionsDisabled;

    public WeightedMaxSatDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
        IOrder iOrder = ((Solver)iPBSolver).getOrder();
        if (iOrder instanceof VarOrderHeapObjective) {
            ((VarOrderHeapObjective)iOrder).setObjectiveFunction(this.obj);
        }
    }

    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
        this.lits.ensure(n);
        this.falsifiedWeight = 0L;
        super.setExpectedNumberOfClauses(n);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
    }

    public int[] model() {
        int[] nArray = new int[this.nborigvars];
        for (int i = 0; i < this.nborigvars; ++i) {
            nArray[i] = this.prevfullmodel[i];
        }
        return nArray;
    }

    public void setTopWeight(int n) {
        this.top = n;
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = iVecInt.get(0);
        if (n < this.top) {
            BigInteger bigInteger = BigInteger.valueOf(n);
            if (iVecInt.size() == 2) {
                int n2 = -iVecInt.get(1);
                int n3 = this.lits.containsAt(n2);
                if (n3 != -1) {
                    this.coefs.set(n3, (Object)((BigInteger)this.coefs.get(n3)).add(bigInteger));
                } else {
                    n3 = this.lits.containsAt(-n2);
                    if (n3 != -1) {
                        this.falsifiedWeight += (long)n;
                        BigInteger bigInteger2 = (BigInteger)this.coefs.get(n3);
                        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
                        if (bigInteger3.signum() > 0) {
                            this.coefs.set(n3, (Object)bigInteger3);
                        } else if (bigInteger3.signum() < 0) {
                            this.lits.set(n3, n2);
                            this.coefs.set(n3, (Object)bigInteger3.abs());
                            this.falsifiedWeight += (long)bigInteger3.intValue();
                        } else {
                            if (!$assertionsDisabled && bigInteger3.signum() != 0) {
                                throw new AssertionError();
                            }
                            this.lits.delete(n3);
                            this.coefs.delete(n3);
                        }
                    } else {
                        this.lits.push(n2);
                        this.coefs.push((Object)bigInteger);
                    }
                }
                return null;
            }
            this.coefs.push((Object)bigInteger);
            int n4 = this.nborigvars + ++this.nbnewvar;
            iVecInt.set(0, n4);
            this.lits.push(n4);
        } else {
            iVecInt.delete(0);
        }
        return super.addClause(iVecInt);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = super.isSatisfiable(true);
        if (bl) {
            int n = this.nborigvars + this.nbnewvar;
            if (this.prevfullmodel == null) {
                this.prevfullmodel = new int[n];
            }
            for (int i = 1; i <= n; ++i) {
                this.prevfullmodel[i - 1] = super.model(i) ? i : -i;
            }
        }
        return bl;
    }

    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        super.reset();
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        this.counter = 0;
        int[] nArray = this.prevfullmodel;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = this.lits.containsAt(n2);
            if (n3 == -1) continue;
            this.counter += ((BigInteger)this.coefs.get(n3)).intValue();
        }
        return new Long(this.falsifiedWeight + (long)this.counter);
    }

    public void discard() throws ContradictionException {
        if (!$assertionsDisabled && this.lits.size() != this.coefs.size()) {
            throw new AssertionError();
        }
        super.addPseudoBoolean(this.lits, this.coefs, false, BigInteger.valueOf(this.counter - 1));
    }

    static {
        $assertionsDisabled = !WeightedMaxSatDecorator.class.desiredAssertionStatus();
    }
}

