/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.AbstractLauncher;
import org.sat4j.csp.SolverFactory;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ISolver;

public class CSPLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected ISolver configureSolver(String[] stringArray) {
        ISolver iSolver = SolverFactory.newDefault();
        this.log(iSolver.toString("c "));
        return iSolver;
    }

    protected Reader createReader(ISolver iSolver, String string) {
        Reader reader;
        if (string.endsWith(".txt")) {
            reader = new CSPExtSupportReader(iSolver);
        } else {
            if (!$assertionsDisabled && !string.endsWith(".xml")) {
                throw new AssertionError();
            }
            reader = new XMLCSPReader(iSolver);
        }
        if (System.getProperty("verbose") != null) {
            this.log("verbose mode on");
            reader.setVerbosity(true);
        }
        return reader;
    }

    public static void main(String[] stringArray) {
        CSPLauncher cSPLauncher = new CSPLauncher();
        if (stringArray.length != 1) {
            ((AbstractLauncher)cSPLauncher).usage();
            return;
        }
        cSPLauncher.run(stringArray);
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("That software uses the Rhino library from the Mozilla project.");
    }

    public void usage() {
        System.out.println("Please provide a CSP instance file!");
    }

    protected String getInstanceName(String[] stringArray) {
        if (!$assertionsDisabled && stringArray.length != 1) {
            throw new AssertionError();
        }
        return stringArray[0];
    }

    static {
        $assertionsDisabled = !CSPLauncher.class.desiredAssertionStatus();
    }
}

