/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import org.sat4j.AbstractOptimizationLauncher;
import org.sat4j.maxsat.SolverFactory;
import org.sat4j.opt.MaxSatDecorator;
import org.sat4j.opt.WeightedMaxSatDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ISolver;

public class MaxSatLauncher
extends AbstractOptimizationLauncher {
    private static final long serialVersionUID = 1L;

    protected void usage() {
        System.out.println("java -jar sat4jmax instance-name");
    }

    protected Reader createReader(ISolver iSolver, String string) {
        if (string.endsWith(".wcnf")) {
            return new DimacsReader(iSolver, "wcnf");
        }
        return new DimacsReader(iSolver);
    }

    protected String getInstanceName(String[] stringArray) {
        return stringArray[0];
    }

    protected ISolver configureSolver(String[] stringArray) {
        int n = stringArray.length - 1;
        if (stringArray[n].endsWith(".wcnf")) {
            return new WeightedMaxSatDecorator(SolverFactory.newLight());
        }
        return new MaxSatDecorator(SolverFactory.newMiniMaxSAT());
    }

    public static void main(String[] stringArray) {
        MaxSatLauncher maxSatLauncher = new MaxSatLauncher();
        if (stringArray.length != 1) {
            maxSatLauncher.usage();
            return;
        }
        maxSatLauncher.run(stringArray);
    }
}

