/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.opt;

import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IPBSolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.PBSolverDecorator;

public class WeightedMaxSatDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    protected int nborigvars;
    private int nbexpectedclauses;
    protected int nbnewvar;
    protected int[] prevfullmodel;
    private final IVec<BigInteger> coefs = new Vec();
    protected int top = -1;
    private BigInteger counter;
    private final IVecInt lits = new VecInt();
    static final /* synthetic */ boolean $assertionsDisabled;

    public WeightedMaxSatDecorator(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    public int newVar(int n) {
        this.nborigvars = super.newVar(n);
        return this.nborigvars;
    }

    public void setExpectedNumberOfClauses(int n) {
        this.nbexpectedclauses = n;
        this.lits.ensure(n);
        super.setExpectedNumberOfClauses(n);
        super.newVar(this.nborigvars + this.nbexpectedclauses);
    }

    public int[] model() {
        int n = this.nborigvars - 1;
        while (Math.abs(this.prevfullmodel[n]) > this.nborigvars) {
            --n;
        }
        int[] nArray = new int[n + 1];
        for (int i = 0; i <= n; ++i) {
            nArray[i] = this.prevfullmodel[i];
        }
        return nArray;
    }

    public void setTopWeight(int n) {
        this.top = n;
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = iVecInt.get(0);
        if (n < this.top) {
            this.coefs.push((Object)BigInteger.valueOf(n));
            if (iVecInt.size() == 2) {
                this.lits.push(-iVecInt.get(1));
                return null;
            }
            int n2 = this.nborigvars + ++this.nbnewvar;
            iVecInt.set(0, n2);
            this.lits.push(n2);
        } else {
            iVecInt.delete(0);
        }
        return super.addClause(iVecInt);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        boolean bl = super.isSatisfiable(true);
        if (bl) {
            this.prevfullmodel = super.model();
        }
        return bl;
    }

    public void reset() {
        this.coefs.clear();
        this.lits.clear();
        this.nbnewvar = 0;
        super.reset();
    }

    public boolean hasNoObjectiveFunction() {
        return false;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    public Number calculateObjective() {
        this.counter = BigInteger.ZERO;
        int[] nArray = this.prevfullmodel;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = this.lits.containsAt(n2);
            if (n3 == -1) continue;
            this.counter = this.counter.add((BigInteger)this.coefs.get(n3));
        }
        return this.counter;
    }

    public void discard() throws ContradictionException {
        if (!$assertionsDisabled && this.lits.size() != this.coefs.size()) {
            throw new AssertionError();
        }
        super.addPseudoBoolean(this.lits, this.coefs, false, this.counter.subtract(BigInteger.ONE));
    }

    static {
        $assertionsDisabled = !WeightedMaxSatDecorator.class.desiredAssertionStatus();
    }
}

