/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.opt.MinCostDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ISolver;

public class P2DimacsReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public P2DimacsReader(MinCostDecorator minCostDecorator) {
        super((ISolver)minCostDecorator, "p2cnf");
    }

    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals(this.formatString))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringTokenizer.nextToken());
        if (!$assertionsDisabled && this.expectedNbOfConstr <= 0) {
            throw new AssertionError();
        }
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
        if ("p2cnf".equals(this.formatString)) {
            String string2 = lineNumberReader.readLine();
            if (!string2.startsWith("min: ")) {
                throw new ParseFormatException("p2 file does not contain the function to minimize!");
            }
            String string3 = string2.substring(5);
            MinCostDecorator minCostDecorator = (MinCostDecorator)this.solver;
            Scanner scanner = new Scanner(string3);
            while (scanner.hasNext()) {
                int n2 = scanner.nextInt();
                if (!$assertionsDisabled && !scanner.hasNext()) {
                    throw new AssertionError();
                }
                int n3 = scanner.nextInt();
                minCostDecorator.setCost(n3, n2);
            }
        }
    }

    static {
        $assertionsDisabled = !P2DimacsReader.class.desiredAssertionStatus();
    }
}

