/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import org.sat4j.opt.WeightedMaxSatDecorator;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.IPBSolver;
import org.sat4j.specs.ISolver;

public class WDimacsReader
extends DimacsReader {
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WDimacsReader(IPBSolver iPBSolver) {
        super((ISolver)iPBSolver, "wcnf");
    }

    public WDimacsReader(IPBSolver iPBSolver, String string) {
        super((ISolver)iPBSolver, string);
    }

    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p cnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals(this.formatString))) {
            throw new ParseFormatException("problem line expected (p cnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(n);
        this.expectedNbOfConstr = Integer.parseInt(stringTokenizer.nextToken());
        if (!$assertionsDisabled && this.expectedNbOfConstr <= 0) {
            throw new AssertionError();
        }
        this.solver.setExpectedNumberOfClauses(this.expectedNbOfConstr);
        if ("wcnf".equals(this.formatString)) {
            int n2 = stringTokenizer.hasMoreTokens() ? Integer.parseInt(stringTokenizer.nextToken()) : Integer.MAX_VALUE;
            ((WeightedMaxSatDecorator)this.solver).setTopWeight(n2);
        }
    }

    static {
        $assertionsDisabled = !WDimacsReader.class.desiredAssertionStatus();
    }
}

