/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.MapPb;
import org.sat4j.pb.constraints.pb.PBConstr;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WatchPb
implements PBConstr,
Undoable,
Serializable {
    public static final boolean ATMOST = false;
    public static final boolean ATLEAST = true;
    protected double activity;
    protected BigInteger[] coefs;
    protected BigInteger degree;
    protected int[] lits;
    protected boolean learnt = false;
    protected boolean locked;
    protected BigInteger watchCumul = BigInteger.ZERO;
    protected ILits voc;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$pb$constraints$pb$WatchPb;

    WatchPb() {
    }

    WatchPb(IDataStructurePB iDataStructurePB) {
        int n = iDataStructurePB.size();
        this.lits = new int[n];
        this.coefs = new BigInteger[n];
        iDataStructurePB.buildConstraintFromMapPb(this.lits, this.coefs);
        this.degree = iDataStructurePB.getDegree();
        this.sort();
    }

    WatchPb(int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        this.lits = nArray;
        this.coefs = bigIntegerArray;
        this.degree = bigInteger;
        this.sort();
    }

    public boolean isAssertive(int n) {
        int n2;
        BigInteger bigInteger = BigInteger.ZERO;
        for (n2 = 0; n2 < this.lits.length; ++n2) {
            if (this.coefs[n2].signum() <= 0 || this.voc.isFalsified(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n) continue;
            bigInteger = bigInteger.add(this.coefs[n2]);
        }
        if ((bigInteger = bigInteger.subtract(this.degree)).signum() < 0) {
            return false;
        }
        for (n2 = 0; n2 < this.lits.length; ++n2) {
            if (this.coefs[n2].signum() <= 0 || !this.voc.isUnassigned(this.lits[n2]) && this.voc.getLevel(this.lits[n2]) < n || bigInteger.compareTo(this.coefs[n2]) >= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public void calcReason(int n, IVecInt iVecInt) {
        for (int n2 : this.lits) {
            if (!this.voc.isFalsified(n2)) continue;
            iVecInt.push(n2 ^ 1);
        }
    }

    protected abstract void computeWatches() throws ContradictionException;

    protected abstract void computePropagation(UnitPropagationListener var1) throws ContradictionException;

    @Override
    public int get(int n) {
        return this.lits[n];
    }

    @Override
    public BigInteger getCoef(int n) {
        return this.coefs[n];
    }

    @Override
    public double getActivity() {
        return this.activity;
    }

    public static IDataStructurePB niceParameters(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger, ILits iLits) throws ContradictionException {
        if (iVecInt.size() == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (iVecInt.size() != iVec.size()) {
            throw new IllegalArgumentException(new StringBuffer().append("Contradiction dans la taille des tableaux ps=").append(iVecInt.size()).append(" coefs=").append(iVec.size()).append(".").toString());
        }
        return WatchPb.niceCheckedParameters(iVecInt, iVec, bl, bigInteger, iLits);
    }

    public static IDataStructurePB niceCheckedParameters(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger, ILits iLits) {
        if (!($assertionsDisabled || iVecInt.size() != 0 && iVecInt.size() == iVec.size())) {
            throw new AssertionError();
        }
        int[] nArray = new int[iVecInt.size()];
        iVecInt.copyTo(nArray);
        BigInteger[] bigIntegerArray = new BigInteger[iVec.size()];
        iVec.copyTo(bigIntegerArray);
        BigInteger bigInteger2 = WatchPb.niceCheckedParametersForCompetition(nArray, bigIntegerArray, bl, bigInteger);
        MapPb mapPb = new MapPb(iLits.nVars() * 2 + 2);
        if (bigInteger2.signum() > 0) {
            bigInteger2 = mapPb.cuttingPlane(nArray, bigIntegerArray, bigInteger2);
        }
        if (bigInteger2.signum() > 0) {
            bigInteger2 = mapPb.saturation();
        }
        if (bigInteger2.signum() <= 0) {
            return null;
        }
        return mapPb;
    }

    public static BigInteger niceParametersForCompetition(int[] nArray, BigInteger[] bigIntegerArray, boolean bl, BigInteger bigInteger) throws ContradictionException {
        if (nArray.length == 0) {
            throw new ContradictionException("Creating Empty clause ?");
        }
        if (nArray.length != bigIntegerArray.length) {
            throw new IllegalArgumentException(new StringBuffer().append("Contradiction dans la taille des tableaux ps=").append(nArray.length).append(" coefs=").append(bigIntegerArray.length).append(".").toString());
        }
        return WatchPb.niceCheckedParametersForCompetition(nArray, bigIntegerArray, bl, bigInteger);
    }

    public static BigInteger niceCheckedParametersForCompetition(int[] nArray, BigInteger[] bigIntegerArray, boolean bl, BigInteger bigInteger) {
        int n;
        BigInteger bigInteger2 = bigInteger;
        if (!bl) {
            for (n = 0; n < nArray.length; ++n) {
                bigIntegerArray[n] = bigIntegerArray[n].negate();
            }
            bigInteger2 = bigInteger2.negate();
        }
        for (n = 0; n < bigIntegerArray.length; ++n) {
            if (bigIntegerArray[n].signum() >= 0) continue;
            nArray[n] = nArray[n] ^ 1;
            bigIntegerArray[n] = bigIntegerArray[n].negate();
            bigInteger2 = bigInteger2.add(bigIntegerArray[n]);
        }
        return bigInteger2;
    }

    @Override
    public void incActivity(double d) {
        this.activity += d;
    }

    public BigInteger slackConstraint() {
        return this.recalcLeftSide().subtract(this.degree);
    }

    public BigInteger slackConstraint(BigInteger[] bigIntegerArray, BigInteger bigInteger) {
        return this.recalcLeftSide(bigIntegerArray).subtract(bigInteger);
    }

    public BigInteger recalcLeftSide(BigInteger[] bigIntegerArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            if (!$assertionsDisabled && bigIntegerArray[i].signum() < 0) {
                throw new AssertionError();
            }
            bigInteger = bigInteger.add(bigIntegerArray[i]);
        }
        return bigInteger;
    }

    public BigInteger recalcLeftSide() {
        return this.recalcLeftSide(this.coefs);
    }

    protected boolean isSatisfiable() {
        return this.recalcLeftSide().compareTo(this.degree) >= 0;
    }

    @Override
    public boolean learnt() {
        return this.learnt;
    }

    @Override
    public boolean locked() {
        return true;
    }

    protected static BigInteger ppcm(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.divide(bigInteger.gcd(bigInteger2)).multiply(bigInteger2);
    }

    @Override
    public void rescaleBy(double d) {
        this.activity *= d;
    }

    void selectionSort(int n, int n2) {
        for (int i = n; i < n2 - 1; ++i) {
            int n3 = i;
            for (int j = i + 1; j < n2; ++j) {
                if (this.coefs[j].compareTo(this.coefs[n3]) <= 0 && (!this.coefs[j].equals(this.coefs[n3]) || this.lits[j] <= this.lits[n3])) continue;
                n3 = j;
            }
            BigInteger bigInteger = this.coefs[i];
            this.coefs[i] = this.coefs[n3];
            this.coefs[n3] = bigInteger;
            int n4 = this.lits[i];
            this.lits[i] = this.lits[n3];
            this.lits[n3] = n4;
        }
    }

    @Override
    public void setLearnt() {
        this.learnt = true;
    }

    @Override
    public boolean simplify() {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < this.lits.length && bigInteger.compareTo(this.degree) < 0; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            bigInteger = bigInteger.add(this.coefs[i]);
        }
        return bigInteger.compareTo(this.degree) >= 0;
    }

    @Override
    public int size() {
        return this.lits.length;
    }

    protected final void sort() {
        if (!$assertionsDisabled && this.lits == null) {
            throw new AssertionError();
        }
        if (this.coefs.length > 0) {
            this.sort(0, this.size());
            BigInteger bigInteger = this.coefs[0];
            for (int i = 1; i < this.coefs.length; ++i) {
                if (!$assertionsDisabled && bigInteger.compareTo(this.coefs[i]) < 0) {
                    throw new AssertionError();
                }
                bigInteger = this.coefs[i];
            }
        }
    }

    protected final void sort(int n, int n2) {
        int n3 = n2 - n;
        if (n3 <= 15) {
            this.selectionSort(n, n2);
        } else {
            int n4 = n3 / 2 + n;
            BigInteger bigInteger = this.coefs[n4];
            int n5 = this.lits[n4];
            int n6 = n - 1;
            int n7 = n2;
            while (true) {
                if (this.coefs[++n6].compareTo(bigInteger) > 0 || this.coefs[n6].equals(bigInteger) && this.lits[n6] > n5) {
                    continue;
                }
                while (bigInteger.compareTo(this.coefs[--n7]) > 0 || this.coefs[n7].equals(bigInteger) && this.lits[n7] < n5) {
                }
                if (n6 >= n7) break;
                BigInteger bigInteger2 = this.coefs[n6];
                this.coefs[n6] = this.coefs[n7];
                this.coefs[n7] = bigInteger2;
                int n8 = this.lits[n6];
                this.lits[n6] = this.lits[n7];
                this.lits[n7] = n8;
            }
            this.sort(n, n6);
            this.sort(n6, n2);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.lits.length > 0) {
            for (int i = 0; i < this.lits.length; ++i) {
                stringBuffer.append(" + ");
                stringBuffer.append(this.coefs[i]);
                stringBuffer.append(".");
                stringBuffer.append(Lits.toString(this.lits[i]));
                stringBuffer.append("[");
                stringBuffer.append(this.voc.valueToString(this.lits[i]));
                stringBuffer.append("@");
                stringBuffer.append(this.voc.getLevel(this.lits[i]));
                stringBuffer.append("]");
                stringBuffer.append(" ");
            }
            stringBuffer.append(">= ");
            stringBuffer.append(this.degree);
        }
        return stringBuffer.toString();
    }

    @Override
    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        BigInteger bigInteger = this.slackConstraint();
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || bigInteger.compareTo(this.coefs[i]) >= 0) continue;
            boolean bl = unitPropagationListener.enqueue(this.lits[i], this);
            if (!$assertionsDisabled && !bl) {
                throw new AssertionError();
            }
        }
    }

    @Override
    public BigInteger getDegree() {
        return this.degree;
    }

    @Override
    public void register() {
        block3: {
            if (!$assertionsDisabled && !this.learnt) {
                throw new AssertionError();
            }
            try {
                this.computeWatches();
            }
            catch (ContradictionException contradictionException) {
                System.out.println(this);
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public static IVec<BigInteger> toVecBigInt(IVecInt iVecInt) {
        Vec<BigInteger> vec = new Vec<BigInteger>(iVecInt.size());
        for (int i = 0; i < iVecInt.size(); ++i) {
            vec.push(BigInteger.valueOf(iVecInt.get(i)));
        }
        return vec;
    }

    public static BigInteger toBigInt(int n) {
        return BigInteger.valueOf(n);
    }

    @Override
    public BigInteger[] getCoefs() {
        BigInteger[] bigIntegerArray = new BigInteger[this.coefs.length];
        System.arraycopy(this.coefs, 0, bigIntegerArray, 0, this.coefs.length);
        return bigIntegerArray;
    }

    @Override
    public int[] getLits() {
        int[] nArray = new int[this.lits.length];
        System.arraycopy(this.lits, 0, nArray, 0, this.lits.length);
        return nArray;
    }

    @Override
    public ILits getVocabulary() {
        return this.voc;
    }

    @Override
    public IVecInt computeAnImpliedClause() {
        BigInteger bigInteger = BigInteger.ZERO;
        int n = this.coefs.length;
        while (bigInteger.compareTo(this.degree) > 0 && n > 0) {
            bigInteger = bigInteger.add(this.coefs[--n]);
        }
        if (n > 0 && n < this.size() / 2) {
            VecInt vecInt = new VecInt(n);
            for (int i = 0; i <= n; ++i) {
                vecInt.push(this.lits[i]);
            }
            return vecInt;
        }
        return null;
    }

    public boolean coefficientsEqualToOne() {
        return false;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            WatchPb watchPb = (WatchPb)object;
            if (!this.degree.equals(watchPb.degree) || this.coefs.length != watchPb.coefs.length || this.lits.length != watchPb.lits.length) {
                return false;
            }
            for (int i = 0; i < this.coefs.length; ++i) {
                int n = this.lits[i];
                boolean bl = false;
                for (int j = 0; j < this.coefs.length; ++j) {
                    if (watchPb.lits[j] != n) continue;
                    if (!watchPb.coefs[j].equals(this.coefs[i])) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 0L;
        for (int n : this.lits) {
            l += (long)n;
        }
        return (int)l / this.lits.length;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$pb$constraints$pb$WatchPb == null ? (class$org$sat4j$pb$constraints$pb$WatchPb = WatchPb.class$("org.sat4j.pb.constraints.pb.WatchPb")) : class$org$sat4j$pb$constraints$pb$WatchPb).desiredAssertionStatus();
    }
}

