/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IPBSolver;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.IVec;

public class GoodOPBReader
extends Reader
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMENT_SYMBOL = "*";
    private final IPBSolver solver;
    private final Map<String, Integer> map = new HashMap<String, Integer>();
    private final IVec<String> decode = new Vec<String>();
    static final /* synthetic */ boolean $assertionsDisabled;

    public GoodOPBReader(IPBSolver iPBSolver) {
        this.solver = iPBSolver;
    }

    public final IProblem parseInstance(java.io.Reader reader) throws ParseFormatException, ContradictionException, IOException {
        return this.parseInstance(new LineNumberReader(reader));
    }

    private IProblem parseInstance(LineNumberReader lineNumberReader) throws ContradictionException, IOException {
        String string;
        this.solver.reset();
        while ((string = lineNumberReader.readLine()) != null) {
            if ((string = string.trim()).endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            this.parseLine(string);
        }
        return this.solver;
    }

    void parseLine(String string) throws ContradictionException {
        if (string.startsWith(COMMENT_SYMBOL)) {
            return;
        }
        if (string.startsWith("p")) {
            return;
        }
        if (string.startsWith("min:") || string.startsWith("min :")) {
            return;
        }
        if (string.startsWith("max:") || string.startsWith("max :")) {
            return;
        }
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        VecInt vecInt = new VecInt();
        Vec<BigInteger> vec = new Vec<BigInteger>();
        Scanner scanner = new Scanner(string).useDelimiter("\\s*\\*\\s*|\\s*\\+\\s*|\\s+");
        while (scanner.hasNext()) {
            Object object;
            String string2 = scanner.next();
            if (">=".equals(string2) || "<=".equals(string2) || "=".equals(string2)) {
                if (!$assertionsDisabled && !scanner.hasNext()) {
                    throw new AssertionError();
                }
                object = scanner.next();
                if (((String)object).startsWith("+")) {
                    object = ((String)object).substring(1);
                }
                BigInteger bigInteger = new BigInteger((String)object);
                try {
                    if (">=".equals(string2) || "=".equals(string2)) {
                        this.solver.addPseudoBoolean(vecInt, vec, true, bigInteger);
                    }
                    if (!"<=".equals(string2) && !"=".equals(string2)) continue;
                    this.solver.addPseudoBoolean(vecInt, vec, false, bigInteger);
                    continue;
                }
                catch (ContradictionException contradictionException) {
                    System.out.println("c inconsistent constraint: " + string);
                    System.out.println("c lits: " + vecInt);
                    System.out.println("c coeffs: " + vec);
                    throw contradictionException;
                }
            }
            if ("+".equals(string2)) {
                if (!$assertionsDisabled && !scanner.hasNext()) {
                    throw new AssertionError();
                }
                string2 = scanner.next();
            } else if ("-".equals(string2)) {
                if (!$assertionsDisabled && !scanner.hasNext()) {
                    throw new AssertionError();
                }
                string2 = string2 + scanner.next();
            }
            try {
                if (string2.startsWith("+")) {
                    string2 = string2.substring(1);
                }
                object = new BigInteger(string2);
                if (!$assertionsDisabled && !scanner.hasNext()) {
                    throw new AssertionError();
                }
                string2 = scanner.next();
            }
            catch (NumberFormatException numberFormatException) {
                object = BigInteger.ONE;
            }
            if ("-".equals(string2) || "~".equals(string2)) {
                if (!$assertionsDisabled && !scanner.hasNext()) {
                    throw new AssertionError();
                }
                string2 = string2 + scanner.next();
            }
            boolean bl = false;
            if (string2.startsWith("+")) {
                string2 = string2.substring(1);
            } else if (string2.startsWith("-")) {
                string2 = string2.substring(1);
                if (!$assertionsDisabled && !((BigInteger)object).equals(BigInteger.ONE)) {
                    throw new AssertionError();
                }
                object = BigInteger.ONE.negate();
            } else if (string2.startsWith("~")) {
                string2 = string2.substring(1);
                bl = true;
            }
            Integer n2 = this.map.get(string2);
            if (n2 == null) {
                n2 = new Integer(this.solver.newVar());
                this.map.put(string2, n2);
                this.decode.push(string2);
                if (!$assertionsDisabled && this.decode.size() != n2.intValue()) {
                    throw new AssertionError();
                }
            }
            vec.push((BigInteger)object);
            int n3 = (bl ? -1 : 1) * n2;
            vecInt.push(n3);
            if (!$assertionsDisabled && vec.size() != vecInt.size()) {
                throw new AssertionError();
            }
        }
    }

    public String decode(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                stringBuffer.append("-");
                stringBuffer.append(this.decode.get(-nArray[i] - 1));
            } else {
                stringBuffer.append(this.decode.get(nArray[i] - 1));
            }
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public void decode(int[] nArray, PrintWriter printWriter) {
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] < 0) {
                printWriter.print("-");
                printWriter.print(this.decode.get(-nArray[i] - 1));
            } else {
                printWriter.print(this.decode.get(nArray[i] - 1));
            }
            printWriter.print(" ");
        }
    }

    static {
        $assertionsDisabled = !GoodOPBReader.class.desiredAssertionStatus();
    }
}

