/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.reader.OPBReader2006;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IPBSolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBReader2007
extends OPBReader2006 {
    private static final long serialVersionUID = 1L;
    private int nbProducts;
    private int nbNewSymbols;
    private Map<String, IVec<String>> productStore = new HashMap<String, IVec<String>>();

    public OPBReader2007(IPBSolver iPBSolver) {
        super(iPBSolver);
    }

    @Override
    protected boolean isGoodFirstCharacter(char c) {
        return Character.isLetter(c) || c == '_' || c == '~';
    }

    @Override
    protected void checkId(StringBuffer stringBuffer) throws ParseFormatException {
        int n;
        int n2 = 1;
        if (stringBuffer.charAt(0) == '~') {
            n2 = 2;
        }
        if ((n = Integer.parseInt(stringBuffer.substring(n2))) > this.nbVars) {
            throw new ParseFormatException("Variable identifier larger than #variables in metadata.");
        }
    }

    @Override
    protected void readTerm(StringBuffer stringBuffer, StringBuffer stringBuffer2) throws IOException, ParseFormatException, ContradictionException {
        this.readInteger(stringBuffer);
        this.skipSpaces();
        stringBuffer2.setLength(0);
        IVec<Object> iVec = new Vec<String>();
        StringBuffer stringBuffer3 = new StringBuffer();
        while (this.readIdentifier(stringBuffer3)) {
            iVec = iVec.push(stringBuffer3.toString());
            this.skipSpaces();
        }
        if (iVec.size() == 0) {
            throw new ParseFormatException("identifier expected");
        }
        if (iVec.size() == 1) {
            stringBuffer2.append((String)iVec.last());
            iVec.pop();
        } else {
            stringBuffer2.append(this.linearizeProduct(iVec));
        }
    }

    protected void literalInAProduct(String string, IVecInt iVecInt) {
        int n = string.charAt(0) == '~' ? 2 : 1;
        int n2 = Integer.parseInt(string.substring(n));
        int n3 = (string.charAt(0) == '~' ? -1 : 1) * n2;
        iVecInt.push(n3);
    }

    protected void negateLiteralInAProduct(String string, IVecInt iVecInt) {
        int n = string.charAt(0) == '~' ? 2 : 1;
        int n2 = Integer.parseInt(string.substring(n));
        int n3 = (string.charAt(0) == '~' ? 1 : -1) * n2;
        iVecInt.push(n3);
    }

    @Override
    protected void readMetaData() throws IOException, ParseFormatException {
        String[] stringArray;
        String string;
        char c = this.get();
        if (c != '*') {
            throw new ParseFormatException("First line of input file should be a comment");
        }
        String string2 = this.readWord();
        if (this.eof() || !"#variable=".equals(string2)) {
            throw new ParseFormatException("First line should contain #variable= as first keyword");
        }
        this.nbVars = Integer.parseInt(this.readWord());
        this.nbNewSymbols = this.nbVars + 1;
        string2 = this.readWord();
        if (this.eof() || !"#constraint=".equals(string2)) {
            throw new ParseFormatException("First line should contain #constraint= as second keyword");
        }
        this.nbConstr = Integer.parseInt(this.readWord());
        this.charAvailable = false;
        if (!this.eol() && (string = this.in.readLine()).indexOf("#product=") != -1 && (stringArray = string.trim().split(" "))[0].equals("#product=")) {
            this.nbProducts = Integer.parseInt(stringArray[1]);
            this.nbVars += this.nbProducts;
            this.nbConstr += 2 * this.nbProducts;
        }
        this.metaData(this.nbVars, this.nbConstr);
    }

    @Override
    protected int translateVarToId(String string) {
        int n = string.charAt(0) == '~' ? 2 : 1;
        int n2 = Integer.parseInt(string.substring(n));
        return (string.charAt(0) == '~' ? -1 : 1) * n2;
    }

    private String linearizeProduct(IVec<String> iVec) throws ContradictionException {
        iVec.sort(String.CASE_INSENSITIVE_ORDER);
        String string = this.getProductVariable(iVec);
        if (string == null) {
            string = new StringBuffer().append("X").append(String.valueOf(this.nbNewSymbols++)).toString();
            this.productStore.put(string, iVec);
            VecInt vecInt = new VecInt();
            Object object = iVec.iterator();
            while (object.hasNext()) {
                this.negateLiteralInAProduct(object.next(), vecInt);
            }
            this.literalInAProduct(string, vecInt);
            this.solver.addClause(vecInt);
            vecInt.clear();
            object = new Vec();
            Iterator<String> iterator = iVec.iterator();
            while (iterator.hasNext()) {
                this.literalInAProduct(iterator.next(), vecInt);
                object.push(BigInteger.ONE);
            }
            this.literalInAProduct(string, vecInt);
            object.push(new BigInteger(String.valueOf(-iVec.size())));
            this.solver.addPseudoBoolean(vecInt, (IVec<BigInteger>)object, true, BigInteger.ZERO);
            this.nbConstraintsRead += 2;
        }
        return string;
    }

    private String getProductVariable(IVec<String> iVec) {
        for (Map.Entry<String, IVec<String>> entry : this.productStore.entrySet()) {
            if (!entry.getValue().equals(iVec)) continue;
            return entry.getKey();
        }
        return null;
    }
}

