/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.util.ArrayList;
import java.util.Collections;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.minisat.orders.ValuedLit;
import org.sat4j.minisat.orders.VarOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JWOrder
extends VarOrder<ILits23> {
    private static final long serialVersionUID = 1L;

    private int computeWeight(int n) {
        int n2 = n << 1;
        int n3 = ((ILits23)this.lits).nBinaryClauses(n2);
        int n4 = ((ILits23)this.lits).nBinaryClauses(n2 ^ 1);
        int n5 = ((ILits23)this.lits).nTernaryClauses(n2);
        int n6 = ((ILits23)this.lits).nTernaryClauses(n2 ^ 1);
        long l = (n3 * n4 * 100 + n3 + n4) * 5 + n5 * n6 * 10 + n5 + n6;
        assert (l <= Integer.MAX_VALUE);
        if (l == 0L) {
            int n7 = ((ILits23)this.lits).watches(n2).size();
            int n8 = ((ILits23)this.lits).watches(n2 ^ 1).size();
            l = n7 + n8;
        }
        return (int)l;
    }

    @Override
    public void init() {
        ValuedLit valuedLit;
        int n;
        super.init();
        ArrayList<ValuedLit> arrayList = new ArrayList<ValuedLit>(this.order.length);
        for (n = 1; n < this.order.length; ++n) {
            valuedLit = new ValuedLit(this.order[n], this.computeWeight(this.order[n] >> 1));
            arrayList.add(valuedLit);
        }
        Collections.sort(arrayList);
        for (n = 0; n < arrayList.size(); ++n) {
            valuedLit = (ValuedLit)arrayList.get(n);
            this.order[n + 1] = valuedLit.id;
            int n2 = valuedLit.id >> 1;
            this.varpos[n2] = n + 1;
            this.activity[valuedLit.id >> 1] = valuedLit.count;
        }
        this.lastVar = 1;
    }

    @Override
    protected void updateActivity(int n) {
        this.activity[n] = this.computeWeight(n);
    }

    @Override
    public String toString() {
        return "Jeroslow-Wang static like heuristics updated when new clauses are learnt";
    }
}

