/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.orders;

import java.io.PrintWriter;
import java.io.Serializable;
import org.sat4j.minisat.core.Heap;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarOrderHeap<L extends ILits>
implements IOrder<L>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final double VAR_RESCALE_FACTOR = 1.0E-100;
    private static final double VAR_RESCALE_BOUND = 1.0E100;
    protected double[] activity = new double[1];
    private double varDecay = 1.0;
    private double varInc = 1.0;
    protected L lits;
    private long nullchoice = 0L;
    protected Heap heap;
    protected int[] phase;

    @Override
    public void setLits(L l) {
        this.lits = l;
    }

    @Override
    public void newVar() {
        this.newVar(1);
    }

    @Override
    public void newVar(int n) {
    }

    @Override
    public int select() {
        while (!this.heap.empty()) {
            int n = this.heap.getmin();
            int n2 = this.phase[n];
            if (!this.lits.isUnassigned(n2)) continue;
            if (this.activity[n] < 1.0E-4) {
                ++this.nullchoice;
            }
            return n2;
        }
        return -1;
    }

    @Override
    public void setVarDecay(double d) {
        this.varDecay = d;
    }

    @Override
    public void undo(int n) {
        if (!this.heap.inHeap(n)) {
            this.heap.insert(n);
        }
    }

    @Override
    public void updateVar(int n) {
        int n2 = n >> 1;
        this.updateActivity(n2);
        this.phase[n2] = n;
        if (this.heap.inHeap(n2)) {
            this.heap.increase(n2);
        }
    }

    protected void updateActivity(int n) {
        int n2 = n;
        double d = this.activity[n2] = this.activity[n2] + this.varInc;
        if (d > 1.0E100) {
            this.varRescaleActivity();
        }
    }

    @Override
    public void varDecayActivity() {
        this.varInc *= this.varDecay;
    }

    private void varRescaleActivity() {
        int n = 1;
        while (n < this.activity.length) {
            int n2 = n++;
            this.activity[n2] = this.activity[n2] * 1.0E-100;
        }
        this.varInc *= 1.0E-100;
    }

    @Override
    public double varActivity(int n) {
        return this.activity[n >> 1];
    }

    public int numberOfInterestingVariables() {
        int n = 0;
        for (int i = 1; i < this.activity.length; ++i) {
            if (!(this.activity[i] > 1.0)) continue;
            ++n;
        }
        return n;
    }

    @Override
    public void init() {
        int n = this.lits.nVars() + 1;
        this.activity = new double[n];
        this.phase = new int[n];
        this.activity[0] = -1.0;
        this.heap = new Heap(this.activity);
        this.heap.setBounds(n);
        for (int i = 1; i < n; ++i) {
            assert (i > 0);
            assert (i <= this.lits.nVars()) : "" + this.lits.nVars() + "/" + i;
            this.activity[i] = 0.0;
            if (this.lits.belongsToPool(i)) {
                this.heap.insert(i);
                this.phase[i] = i << 1 ^ 1;
                continue;
            }
            this.phase[i] = -1;
        }
    }

    public String toString() {
        return "VSIDS like heuristics from MiniSAT using a heap";
    }

    public ILits getVocabulary() {
        return this.lits;
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
        printWriter.println(string + "non guided choices\t" + this.nullchoice);
    }

    @Override
    public void assignLiteral(int n) {
    }
}

