/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.ActivityComparator;
import org.sat4j.minisat.core.ActivityListener;
import org.sat4j.minisat.core.AssertingClauseGenerator;
import org.sat4j.minisat.core.ConflictTimer;
import org.sat4j.minisat.core.ConflictTimerAdapter;
import org.sat4j.minisat.core.ConflictTimerContainer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.Lbool;
import org.sat4j.minisat.core.Learner;
import org.sat4j.minisat.core.LearningStrategy;
import org.sat4j.minisat.core.NullSearchListener;
import org.sat4j.minisat.core.Pair;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchListener;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;
import org.sat4j.minisat.core.Undoable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Solver<L extends ILits, D extends DataStructureFactory<L>>
implements ISolver,
UnitPropagationListener,
ActivityListener,
Learner {
    private static final long serialVersionUID = 1L;
    private static final double CLAUSE_RESCALE_FACTOR = 1.0E-20;
    private static final double CLAUSE_RESCALE_BOUND = 1.0E20;
    private final IVec<Constr> constrs = new Vec<Constr>();
    private final IVec<Constr> learnts = new Vec<Constr>();
    private double claInc = 1.0;
    private double claDecay = 1.0;
    private int qhead = 0;
    protected final IVecInt trail = new VecInt();
    protected final IVecInt trailLim = new VecInt();
    protected int rootLevel;
    private int[] model = null;
    protected L voc;
    private IOrder<L> order;
    private final ActivityComparator comparator = new ActivityComparator();
    private final SolverStats stats = new SolverStats();
    private final LearningStrategy<L, D> learner;
    protected final AssertingClauseGenerator analyzer;
    private volatile boolean undertimeout;
    private long timeout = Integer.MAX_VALUE;
    private boolean timeBasedTimeout = true;
    protected D dsfactory;
    private SearchParams params;
    private final IVecInt __dimacs_out = new VecInt();
    private SearchListener slistener = new NullSearchListener();
    private RestartStrategy restarter;
    private final Map<String, Integer> constrTypes = new HashMap<String, Integer>();
    private boolean[] mseen = new boolean[0];
    private final IVecInt preason = new VecInt();
    private final IVecInt outLearnt = new VecInt();
    public static final ISimplifier NO_SIMPLIFICATION;
    public final ISimplifier SIMPLE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.simpleSimplification(iVecInt);
        }

        public String toString() {
            return "Simple reason simplification";
        }
    };
    public final ISimplifier EXPENSIVE_SIMPLIFICATION = new ISimplifier(){
        private static final long serialVersionUID = 1L;

        public void simplify(IVecInt iVecInt) {
            Solver.this.expensiveSimplification(iVecInt);
        }

        public String toString() {
            return "Expensive reason simplification";
        }
    };
    private ISimplifier simplifier = NO_SIMPLIFICATION;
    private final IVecInt analyzetoclear = new VecInt();
    private final IVecInt analyzestack = new VecInt();
    private final Pair analysisResult = new Pair();
    private boolean[] fullmodel;
    private double timebegin = 0.0;
    private boolean needToReduceDB;
    private ConflictTimer conflictCount;
    private transient Timer timer;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$sat4j$minisat$core$Solver;

    protected IVecInt dimacs2internal(IVecInt iVecInt) {
        this.__dimacs_out.clear();
        this.__dimacs_out.ensure(iVecInt.size());
        for (int i = 0; i < iVecInt.size(); ++i) {
            if (!$assertionsDisabled && iVecInt.get(i) == 0) {
                throw new AssertionError();
            }
            this.__dimacs_out.unsafePush(this.voc.getFromPool(iVecInt.get(i)));
        }
        return this.__dimacs_out;
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy<L, D> learningStrategy, D d, IOrder<L> iOrder, RestartStrategy restartStrategy) {
        this(assertingClauseGenerator, learningStrategy, d, new SearchParams(), iOrder, restartStrategy);
    }

    public Solver(AssertingClauseGenerator assertingClauseGenerator, LearningStrategy<L, D> learningStrategy, D d, SearchParams searchParams, IOrder<L> iOrder, RestartStrategy restartStrategy) {
        this.analyzer = assertingClauseGenerator;
        this.learner = learningStrategy;
        this.order = iOrder;
        this.params = searchParams;
        this.setDataStructureFactory(d);
        this.restarter = restartStrategy;
    }

    public final void setDataStructureFactory(D d) {
        this.dsfactory = d;
        this.dsfactory.setUnitPropagationListener(this);
        this.dsfactory.setLearner(this);
        this.voc = d.getVocabulary();
        this.order.setLits(this.voc);
    }

    public void setSearchListener(SearchListener searchListener) {
        this.slistener = searchListener;
    }

    @Override
    public void setTimeout(int n) {
        this.timeout = (long)n * 1000L;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutMs(long l) {
        this.timeout = l;
        this.timeBasedTimeout = true;
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
        this.timeout = n;
        this.timeBasedTimeout = false;
    }

    public void setSearchParams(SearchParams searchParams) {
        this.params = searchParams;
    }

    public void setRestartStrategy(RestartStrategy restartStrategy) {
        this.restarter = restartStrategy;
    }

    @Override
    public void expireTimeout() {
        this.undertimeout = false;
    }

    protected int nAssigns() {
        return this.trail.size();
    }

    @Override
    public int nConstraints() {
        return this.constrs.size();
    }

    @Override
    public void learn(Constr constr) {
        this.learnts.push(constr);
        constr.setLearnt();
        constr.register();
        ++this.stats.learnedclauses;
        switch (constr.size()) {
            case 2: {
                ++this.stats.learnedbinaryclauses;
                break;
            }
            case 3: {
                ++this.stats.learnedternaryclauses;
                break;
            }
        }
    }

    public int decisionLevel() {
        return this.trailLim.size();
    }

    @Override
    @Deprecated
    public int newVar() {
        int n = this.voc.nVars() + 1;
        this.voc.ensurePool(n);
        return n;
    }

    @Override
    public int newVar(int n) {
        this.voc.ensurePool(n);
        return this.voc.nVars();
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createClause(iVecInt2));
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        if (iConstr == null) {
            throw new UnsupportedOperationException("Reference to the constraint to remove needed!");
        }
        Constr constr = (Constr)iConstr;
        constr.remove();
        this.constrs.remove(constr);
        this.clearLearntClauses();
        this.cancelLearntLiterals();
        return true;
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        Iterator<IVecInt> iterator = iVec.iterator();
        while (iterator.hasNext()) {
            this.addClause(iterator.next());
        }
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        int n2 = iVecInt.size();
        VecInt vecInt = new VecInt(n2);
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            vecInt.push(-iteratorInt.next());
        }
        return this.addAtLeast(vecInt, n2 - n);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        IVecInt iVecInt2 = this.dimacs2internal(iVecInt);
        return this.addConstr(this.dsfactory.createCardinalityConstraint(iVecInt2, n));
    }

    public boolean simplifyDB() {
        IVec[] iVecArray = new IVec[]{this.constrs, this.learnts};
        for (int i = 0; i < 2; ++i) {
            int n = 0;
            for (int j = 0; j < iVecArray[i].size(); ++j) {
                if (((Constr)iVecArray[i].get(j)).simplify()) {
                    ((Constr)iVecArray[i].get(j)).remove();
                    continue;
                }
                iVecArray[i].moveTo(n++, j);
            }
            iVecArray[i].shrinkTo(n);
        }
        return true;
    }

    @Override
    public int[] model() {
        if (this.model == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        int[] nArray = new int[this.model.length];
        System.arraycopy(this.model, 0, nArray, 0, this.model.length);
        return nArray;
    }

    @Override
    public boolean enqueue(int n) {
        return this.enqueue(n, null);
    }

    @Override
    public boolean enqueue(int n, Constr constr) {
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        if (this.voc.isSatisfied(n)) {
            return true;
        }
        if (this.voc.isFalsified(n)) {
            return false;
        }
        this.voc.satisfies(n);
        this.voc.setLevel(n, this.decisionLevel());
        this.voc.setReason(n, constr);
        this.trail.push(n);
        return true;
    }

    public void analyze(Constr constr, Pair pair) {
        int n;
        if (!$assertionsDisabled && constr == null) {
            throw new AssertionError();
        }
        this.outLearnt.clear();
        boolean[] blArray = this.mseen;
        if (!$assertionsDisabled && this.outLearnt.size() != 0) {
            throw new AssertionError();
        }
        for (n = 0; n < blArray.length; ++n) {
            blArray[n] = false;
        }
        this.analyzer.initAnalyze();
        n = -1;
        this.outLearnt.push(-1);
        int n2 = 0;
        do {
            this.preason.clear();
            if (!$assertionsDisabled && constr == null) {
                throw new AssertionError();
            }
            constr.calcReason(n, this.preason);
            if (constr.learnt()) {
                this.claBumpActivity(constr);
            }
            for (int i = 0; i < this.preason.size(); ++i) {
                int n3 = this.preason.get(i);
                this.order.updateVar(n3);
                if (blArray[n3 >> 1]) continue;
                blArray[n3 >> 1] = true;
                if (this.voc.getLevel(n3) == this.decisionLevel()) {
                    this.analyzer.onCurrentDecisionLevelLiteral(n3);
                    continue;
                }
                if (this.voc.getLevel(n3) <= 0) continue;
                this.outLearnt.push(n3 ^ 1);
                n2 = Math.max(n2, this.voc.getLevel(n3));
            }
            do {
                n = this.trail.last();
                constr = this.voc.getReason(n);
                this.undoOne();
            } while (!blArray[n >> 1]);
        } while (this.analyzer.clauseNonAssertive(constr));
        this.outLearnt.set(0, n ^ 1);
        this.simplifier.simplify(this.outLearnt);
        Constr constr2 = this.dsfactory.createUnregisteredClause(this.outLearnt);
        this.slistener.learn(constr2);
        pair.reason = constr2;
        if (!$assertionsDisabled && n2 <= -1) {
            throw new AssertionError();
        }
        pair.backtrackLevel = n2;
    }

    public void setSimplifier(String string) {
        try {
            Field field = (class$org$sat4j$minisat$core$Solver == null ? (class$org$sat4j$minisat$core$Solver = Solver.class$("org.sat4j.minisat.core.Solver")) : class$org$sat4j$minisat$core$Solver).getDeclaredField(string);
            this.simplifier = (ISimplifier)field.get(this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.simplifier = NO_SIMPLIFICATION;
        }
    }

    public void setSimplifier(ISimplifier iSimplifier) {
        this.simplifier = iSimplifier;
    }

    private void simpleSimplification(IVecInt iVecInt) {
        int n;
        boolean[] blArray = this.mseen;
        int n2 = 1;
        block0: for (n = 1; n < iVecInt.size(); ++n) {
            Constr constr = this.voc.getReason(iVecInt.get(n));
            if (constr == null) {
                iVecInt.moveTo(n2++, n);
                continue;
            }
            for (int i = 0; i < constr.size(); ++i) {
                if (!this.voc.isFalsified(constr.get(i)) || blArray[constr.get(i) >> 1] || this.voc.getLevel(constr.get(i)) == 0) continue;
                iVecInt.moveTo(n2++, n);
                continue block0;
            }
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    private void expensiveSimplification(IVecInt iVecInt) {
        int n;
        this.analyzetoclear.clear();
        iVecInt.copyTo(this.analyzetoclear);
        int n2 = 1;
        for (n = 1; n < iVecInt.size(); ++n) {
            if (this.voc.getReason(iVecInt.get(n)) != null && this.analyzeRemovable(iVecInt.get(n))) continue;
            iVecInt.moveTo(n2++, n);
        }
        iVecInt.shrink(n - n2);
        this.stats.reducedliterals += (long)(n - n2);
    }

    private boolean analyzeRemovable(int n) {
        if (!$assertionsDisabled && this.voc.getReason(n) == null) {
            throw new AssertionError();
        }
        this.analyzestack.clear();
        this.analyzestack.push(n);
        boolean[] blArray = this.mseen;
        int n2 = this.analyzetoclear.size();
        while (this.analyzestack.size() > 0) {
            int n3 = this.analyzestack.last();
            if (!$assertionsDisabled && this.voc.getReason(n3) == null) {
                throw new AssertionError();
            }
            Constr constr = this.voc.getReason(n3);
            this.analyzestack.pop();
            for (int i = 0; i < constr.size(); ++i) {
                int n4 = constr.get(i);
                if (!this.voc.isFalsified(n4) || blArray[LiteralsUtils.var(n4)] || this.voc.getLevel(n4) == 0) continue;
                if (this.voc.getReason(n4) == null) {
                    for (int j = n2; j < this.analyzetoclear.size(); ++j) {
                        blArray[this.analyzetoclear.get((int)j) >> 1] = false;
                    }
                    this.analyzetoclear.shrink(this.analyzetoclear.size() - n2);
                    return false;
                }
                blArray[n4 >> 1] = true;
                this.analyzestack.push(n4);
                this.analyzetoclear.push(n4);
            }
        }
        return true;
    }

    public static int decode2dimacs(int n) {
        return ((n & 1) == 0 ? 1 : -1) * (n >> 1);
    }

    protected void undoOne() {
        int n = this.trail.last();
        if (!$assertionsDisabled && n <= 1) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.voc.getLevel(n) < 0) {
            throw new AssertionError();
        }
        int n2 = n >> 1;
        this.voc.unassign(n);
        this.voc.setReason(n, null);
        this.voc.setLevel(n, -1);
        this.order.undo(n2);
        this.trail.pop();
        IVec<Undoable> iVec = this.voc.undos(n);
        if (!$assertionsDisabled && iVec == null) {
            throw new AssertionError();
        }
        while (iVec.size() > 0) {
            iVec.last().undo(n);
            iVec.pop();
        }
    }

    @Override
    public void claBumpActivity(Constr constr) {
        constr.incActivity(this.claInc);
        if (constr.getActivity() > 1.0E20) {
            this.claRescalActivity();
        }
    }

    @Override
    public void varBumpActivity(int n) {
        this.order.updateVar(n);
    }

    private void claRescalActivity() {
        for (int i = 0; i < this.learnts.size(); ++i) {
            this.learnts.get(i).rescaleBy(1.0E-20);
        }
        this.claInc *= 1.0E-20;
    }

    public Constr propagate() {
        while (this.qhead < this.trail.size()) {
            ++this.stats.propagations;
            int n = this.trail.get(this.qhead++);
            this.slistener.propagating(Solver.decode2dimacs(n));
            this.order.assignLiteral(n);
            if (!$assertionsDisabled && n <= 1) {
                throw new AssertionError();
            }
            IVec<Propagatable> iVec = this.dsfactory.getWatchesFor(n);
            int n2 = iVec.size();
            for (int i = 0; i < n2; ++i) {
                ++this.stats.inspects;
                if (iVec.get(i).propagate(this, n)) continue;
                this.dsfactory.conflictDetectedInWatchesFor(n, i);
                this.qhead = this.trail.size();
                return (Constr)iVec.get(i);
            }
        }
        return null;
    }

    void record(Constr constr) {
        constr.assertConstraint(this);
        this.slistener.adding(Solver.decode2dimacs(constr.get(0)));
        if (constr.size() == 1) {
            ++this.stats.learnedliterals;
        } else {
            this.learner.learns(constr);
        }
    }

    public boolean assume(int n) {
        if (!$assertionsDisabled && this.trail.size() != this.qhead) {
            throw new AssertionError();
        }
        this.trailLim.push(this.trail.size());
        return this.enqueue(n);
    }

    private void cancel() {
        int n = this.trail.unsafeGet(this.trailLim.last());
        this.slistener.backtracking(Solver.decode2dimacs(n));
        for (int i = this.trail.size() - this.trailLim.last(); i > 0; --i) {
            this.undoOne();
        }
        this.trailLim.pop();
    }

    private void cancelLearntLiterals() {
        for (int i = this.trail.size() - this.rootLevel; i > 0; --i) {
            this.undoOne();
        }
        this.qhead = this.trail.size();
    }

    protected void cancelUntil(int n) {
        while (this.decisionLevel() > n) {
            this.cancel();
        }
        this.qhead = this.trail.size();
    }

    Lbool search(long l) {
        if (!$assertionsDisabled && this.rootLevel != this.decisionLevel()) {
            throw new AssertionError();
        }
        ++this.stats.starts;
        int n = 0;
        this.order.setVarDecay(1.0 / this.params.getVarDecay());
        this.claDecay = 1.0 / this.params.getClaDecay();
        do {
            this.slistener.beginLoop();
            Constr constr = this.propagate();
            if (!$assertionsDisabled && this.trail.size() != this.qhead) {
                throw new AssertionError();
            }
            if (constr == null) {
                if (!$assertionsDisabled && this.nAssigns() > this.voc.realnVars()) {
                    throw new AssertionError();
                }
                if (this.nAssigns() == this.voc.realnVars()) {
                    this.slistener.solutionFound();
                    this.modelFound();
                    return Lbool.TRUE;
                }
                if ((long)n >= l) {
                    this.cancelUntil(this.rootLevel);
                    return Lbool.UNDEFINED;
                }
                if (this.needToReduceDB) {
                    this.reduceDB();
                    this.needToReduceDB = false;
                }
                ++this.stats.decisions;
                int n2 = this.order.select();
                if (!$assertionsDisabled && n2 <= 1) {
                    throw new AssertionError();
                }
                this.slistener.assuming(Solver.decode2dimacs(n2));
                boolean bl = this.assume(n2);
                if (!$assertionsDisabled && !bl) {
                    throw new AssertionError();
                }
                continue;
            }
            ++this.stats.conflicts;
            ++n;
            this.slistener.conflictFound();
            this.conflictCount.newConflict();
            if (this.decisionLevel() == this.rootLevel) {
                return Lbool.FALSE;
            }
            this.analyze(constr, this.analysisResult);
            if (!$assertionsDisabled && this.analysisResult.backtrackLevel >= this.decisionLevel()) {
                throw new AssertionError();
            }
            this.cancelUntil(Math.max(this.analysisResult.backtrackLevel, this.rootLevel));
            if (!($assertionsDisabled || this.decisionLevel() >= this.rootLevel && this.decisionLevel() >= this.analysisResult.backtrackLevel)) {
                throw new AssertionError();
            }
            if (this.analysisResult.reason == null) {
                return Lbool.FALSE;
            }
            this.record(this.analysisResult.reason);
            this.analysisResult.reason = null;
            this.decayActivities();
        } while (this.undertimeout);
        return Lbool.UNDEFINED;
    }

    protected void analyzeAtRootLevel(Constr constr) {
    }

    void modelFound() {
        this.model = new int[this.trail.size()];
        this.fullmodel = new boolean[this.nVars()];
        int n = 0;
        for (int i = 1; i <= this.voc.nVars(); ++i) {
            int n2;
            if (!this.voc.belongsToPool(i) || this.voc.isUnassigned(n2 = this.voc.getFromPool(i))) continue;
            this.model[n++] = this.voc.isSatisfied(n2) ? i : -i;
            this.fullmodel[i - 1] = this.voc.isSatisfied(n2);
        }
        if (!$assertionsDisabled && n != this.model.length) {
            throw new AssertionError();
        }
        this.cancelUntil(this.rootLevel);
    }

    @Override
    public boolean model(int n) {
        if (n <= 0 || n > this.nVars()) {
            throw new IllegalArgumentException("Use a valid Dimacs var id as argument!");
        }
        if (this.fullmodel == null) {
            throw new UnsupportedOperationException("Call the solve method first!!!");
        }
        return this.fullmodel[n - 1];
    }

    protected void reduceDB() {
        this.reduceDB(this.claInc / (double)this.learnts.size());
    }

    @Override
    public void clearLearntClauses() {
        Iterator<Constr> iterator = this.learnts.iterator();
        while (iterator.hasNext()) {
            iterator.next().remove();
        }
        this.learnts.clear();
    }

    protected void reduceDB(double d) {
        int n;
        this.sortOnActivity();
        ++this.stats.reduceddb;
        int n2 = 0;
        for (n = 0; n < this.learnts.size() / 2; ++n) {
            Constr constr = this.learnts.get(n);
            if (constr.locked()) {
                this.learnts.set(n2++, this.learnts.get(n));
                continue;
            }
            constr.remove();
        }
        while (n < this.learnts.size()) {
            this.learnts.set(n2++, this.learnts.get(n));
            ++n;
        }
        System.out.println(new StringBuffer().append("c cleaning ").append(this.learnts.size() - n2).append(" clauses out of ").append(this.learnts.size()).append(" for limit ").append(d).toString());
        this.learnts.shrinkTo(n2);
    }

    private void sortOnActivity() {
        this.learnts.sort(this.comparator);
    }

    protected void decayActivities() {
        this.order.varDecayActivity();
        this.claDecayActivity();
    }

    private void claDecayActivity() {
        this.claInc *= this.claDecay;
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, bl);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        return this.isSatisfiable(iVecInt, false);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        Object object;
        Lbool lbool = Lbool.UNDEFINED;
        int n = this.voc.nVars();
        if (this.mseen.length < n) {
            this.mseen = new boolean[n + 1];
        }
        this.trail.ensure(n);
        this.trailLim.ensure(n);
        this.order.init();
        this.learner.init();
        this.restarter.init(this.params);
        this.timebegin = System.currentTimeMillis();
        this.slistener.start();
        this.model = null;
        this.fullmodel = null;
        Constr constr = this.propagate();
        if (constr != null) {
            this.analyzeAtRootLevel(constr);
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            return false;
        }
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            if (this.assume(this.voc.getFromPool(iteratorInt.next())) && this.propagate() == null) continue;
            this.slistener.end(Lbool.FALSE);
            this.cancelUntil(0);
            return false;
        }
        this.rootLevel = this.decisionLevel();
        final long l = Runtime.getRuntime().freeMemory() / 10L;
        ConflictTimerAdapter conflictTimerAdapter = new ConflictTimerAdapter(500){
            private static final long serialVersionUID = 1L;

            void run() {
                long l2 = Runtime.getRuntime().freeMemory();
                if (l2 < l) {
                    Solver.this.needToReduceDB = true;
                }
            }
        };
        if (this.timeBasedTimeout) {
            if (!bl || this.timer == null) {
                object = new TimerTask(){

                    public void run() {
                        Solver.this.undertimeout = false;
                    }
                };
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)object, this.timeout);
                this.conflictCount = conflictTimerAdapter;
            }
        } else if (!bl || this.conflictCount == null) {
            object = new ConflictTimerAdapter((int)this.timeout){
                private static final long serialVersionUID = 1L;

                public void run() {
                    Solver.this.undertimeout = false;
                }
            };
            this.conflictCount = new ConflictTimerContainer().add((ConflictTimer)object).add(conflictTimerAdapter);
        }
        this.needToReduceDB = false;
        this.undertimeout = true;
        while (lbool == Lbool.UNDEFINED && this.undertimeout) {
            lbool = this.search(this.restarter.nextRestartNumberOfConflict());
            this.restarter.onRestart();
        }
        this.cancelUntil(0);
        if (!bl && this.timeBasedTimeout) {
            this.timer.cancel();
            this.timer = null;
        }
        this.slistener.end(lbool);
        if (!this.undertimeout) {
            throw new TimeoutException(new StringBuffer().append(" Timeout (").append(this.timeout).append("s) exceeded").toString());
        }
        return lbool == Lbool.TRUE;
    }

    @Override
    public void printInfos(PrintWriter printWriter, String string) {
        printWriter.print(string);
        printWriter.println("constraints type ");
        for (Map.Entry<String, Integer> entry : this.constrTypes.entrySet()) {
            printWriter.println(new StringBuffer().append(string).append(entry.getKey()).append(" => ").append(entry.getValue()).toString());
        }
    }

    public SolverStats getStats() {
        return this.stats;
    }

    public IOrder<L> getOrder() {
        return this.order;
    }

    public void setOrder(IOrder<L> iOrder) {
        this.order = iOrder;
        this.order.setLits(this.voc);
    }

    public L getVocabulary() {
        return this.voc;
    }

    @Override
    public void reset() {
        this.voc.resetPool();
        this.dsfactory.reset();
        this.constrs.clear();
        this.learnts.clear();
        this.stats.reset();
        this.constrTypes.clear();
    }

    @Override
    public int nVars() {
        return this.voc.nVars();
    }

    protected IConstr addConstr(Constr constr) {
        if (constr != null) {
            this.constrs.push(constr);
            String string = constr.getClass().getName();
            Integer n = this.constrTypes.get(string);
            if (n == null) {
                this.constrTypes.put(string, new Integer(1));
            } else {
                this.constrTypes.put(string, new Integer(n + 1));
            }
        }
        return constr;
    }

    public DataStructureFactory<L> getDSFactory() {
        return this.dsfactory;
    }

    public IVecInt getOutLearnt() {
        return this.outLearnt;
    }

    public IConstr getIthConstr(int n) {
        return this.constrs.get(n);
    }

    @Override
    public void printStat(PrintStream printStream, String string) {
        this.printStat(new PrintWriter(printStream), string);
    }

    @Override
    public void printStat(PrintWriter printWriter, String string) {
        this.stats.printStat(printWriter, string);
        double d = ((double)System.currentTimeMillis() - this.timebegin) / 1000.0;
        printWriter.println(new StringBuffer().append(string).append("speed (assignments/second)\t: ").append((double)this.stats.propagations / d).toString());
        this.order.printStat(printWriter, string);
    }

    @Override
    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = new Object[]{this.analyzer, this.dsfactory, this.learner, this.params, this.order, this.simplifier, this.restarter};
        stringBuffer.append(string);
        stringBuffer.append("--- Begin Solver configuration ---");
        stringBuffer.append("\n");
        for (Object object : objectArray) {
            stringBuffer.append(string);
            stringBuffer.append(object.toString());
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("timeout=");
        if (this.timeBasedTimeout) {
            stringBuffer.append(this.timeout / 1000L);
            stringBuffer.append("s\n");
        } else {
            stringBuffer.append(this.timeout);
            stringBuffer.append(" conflicts\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("--- End Solver configuration ---");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public int getTimeout() {
        return (int)(this.timeBasedTimeout ? this.timeout / 1000L : this.timeout);
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.constrs.ensure(n);
    }

    @Override
    public Map<String, Number> getStat() {
        return this.stats.toMap();
    }

    @Override
    public int[] findModel() throws TimeoutException {
        if (this.isSatisfiable()) {
            return this.model();
        }
        return null;
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        if (this.isSatisfiable(iVecInt)) {
            return this.model();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        $assertionsDisabled = !(class$org$sat4j$minisat$core$Solver == null ? (class$org$sat4j$minisat$core$Solver = Solver.class$("org.sat4j.minisat.core.Solver")) : class$org$sat4j$minisat$core$Solver).desiredAssertionStatus();
        NO_SIMPLIFICATION = new ISimplifier(){
            private static final long serialVersionUID = 1L;

            public void simplify(IVecInt iVecInt) {
            }

            public String toString() {
                return "No reason simplification";
            }
        };
    }

    static interface ISimplifier
    extends Serializable {
        public void simplify(IVecInt var1);
    }
}

