/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat;

import org.sat4j.core.ASolverFactory;
import org.sat4j.minisat.constraints.CardinalityDataStructure;
import org.sat4j.minisat.constraints.ClausalDataStructureCB;
import org.sat4j.minisat.constraints.ClausalDataStructureCBHT;
import org.sat4j.minisat.constraints.MixedDataStructureDaniel;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinary;
import org.sat4j.minisat.constraints.MixedDataStructureWithBinaryAndTernary;
import org.sat4j.minisat.core.DataStructureFactory;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits2;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.minisat.core.IOrder;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.Solver;
import org.sat4j.minisat.learning.ActiveLearning;
import org.sat4j.minisat.learning.FixedLengthLearning;
import org.sat4j.minisat.learning.MiniSATLearning;
import org.sat4j.minisat.learning.NoLearningButHeuristics;
import org.sat4j.minisat.learning.PercentLengthLearning;
import org.sat4j.minisat.orders.JWOrder;
import org.sat4j.minisat.orders.MyOrder;
import org.sat4j.minisat.orders.PureOrder;
import org.sat4j.minisat.orders.RSATPhaseSelectionStrategy;
import org.sat4j.minisat.orders.VarOrder;
import org.sat4j.minisat.orders.VarOrderHeap;
import org.sat4j.minisat.restarts.ArminRestarts;
import org.sat4j.minisat.restarts.LubyRestarts;
import org.sat4j.minisat.restarts.MiniSATRestarts;
import org.sat4j.minisat.uip.DecisionUIP;
import org.sat4j.minisat.uip.FirstUIP;
import org.sat4j.opt.MinOneDecorator;
import org.sat4j.specs.ISolver;
import org.sat4j.tools.DimacsOutputSolver;
import org.sat4j.tools.OptToSatAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolverFactory
extends ASolverFactory<ISolver> {
    private static final long serialVersionUID = 1L;
    private static SolverFactory instance;

    private SolverFactory() {
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new SolverFactory();
        }
    }

    public static SolverFactory instance() {
        if (instance == null) {
            SolverFactory.createInstance();
        }
        return instance;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearning() {
        return SolverFactory.newMiniLearning(10);
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureDaniel());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeapEZSimp() {
        Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newMiniLearningHeap();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeapExpSimp() {
        Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newMiniLearningHeap();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeapRsatExpSimp() {
        Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newMiniLearningHeapExpSimp();
        solver.setOrder(new VarOrderHeap(new RSATPhaseSelectionStrategy()));
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeapRsatExpSimpBiere() {
        Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newMiniLearningHeapRsatExpSimp();
        solver.setRestartStrategy(new ArminRestarts());
        solver.setSearchParams(new SearchParams(1.1, 100));
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeapRsatExpSimpLuby() {
        Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newMiniLearningHeapRsatExpSimp();
        solver.setRestartStrategy(new LubyRestarts());
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearning(int n) {
        return SolverFactory.newMiniLearning(new MixedDataStructureDaniel(), n);
    }

    public static <L extends ILits> Solver<L, DataStructureFactory<L>> newMiniLearning(DataStructureFactory<L> dataStructureFactory) {
        return SolverFactory.newMiniLearning(dataStructureFactory, 10);
    }

    public static <L extends ILits> Solver<L, DataStructureFactory<L>> newMiniLearningHeap(DataStructureFactory<L> dataStructureFactory) {
        return SolverFactory.newMiniLearning(dataStructureFactory, new VarOrderHeap());
    }

    public static Solver<ILits2, DataStructureFactory<ILits2>> newMiniLearning2() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinary());
    }

    public static Solver<ILits2, DataStructureFactory<ILits2>> newMiniLearning2Heap() {
        return SolverFactory.newMiniLearningHeap(new MixedDataStructureWithBinary());
    }

    public static Solver<ILits23, DataStructureFactory<ILits23>> newMiniLearning23() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinaryAndTernary());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningCB() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCB());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningCBWL() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCBHT());
    }

    public static Solver<ILits2, DataStructureFactory<ILits2>> newMiniLearning2NewOrder() {
        return SolverFactory.newMiniLearning(new MixedDataStructureWithBinary(), new MyOrder());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningPure() {
        return SolverFactory.newMiniLearning(new MixedDataStructureDaniel(), new PureOrder());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningCBWLPure() {
        return SolverFactory.newMiniLearning(new ClausalDataStructureCBHT(), new PureOrder());
    }

    public static <L extends ILits> Solver<L, DataStructureFactory<L>> newMiniLearning(DataStructureFactory<L> dataStructureFactory, int n) {
        PercentLengthLearning percentLengthLearning = new PercentLengthLearning(n);
        Solver solver = new Solver(new FirstUIP(), percentLengthLearning, dataStructureFactory, new VarOrder(), new MiniSATRestarts());
        percentLengthLearning.setSolver(solver);
        return solver;
    }

    public static <L extends ILits> Solver<L, DataStructureFactory<L>> newMiniLearning(DataStructureFactory<L> dataStructureFactory, IOrder<L> iOrder) {
        PercentLengthLearning percentLengthLearning = new PercentLengthLearning(10);
        Solver solver = new Solver(new FirstUIP(), percentLengthLearning, dataStructureFactory, iOrder, new MiniSATRestarts());
        percentLengthLearning.setSolver(solver);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningEZSimp() {
        return SolverFactory.newMiniLearningEZSimp(new MixedDataStructureDaniel());
    }

    public static <L extends ILits> Solver<L, DataStructureFactory<L>> newMiniLearningEZSimp(DataStructureFactory<L> dataStructureFactory) {
        PercentLengthLearning percentLengthLearning = new PercentLengthLearning(10);
        Solver solver = new Solver(new FirstUIP(), percentLengthLearning, dataStructureFactory, new VarOrder(), new MiniSATRestarts());
        percentLengthLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeapEZSimpNoRestarts() {
        PercentLengthLearning<ILits, DataStructureFactory<ILits>> percentLengthLearning = new PercentLengthLearning<ILits, DataStructureFactory<ILits>>(10);
        Solver<ILits, DataStructureFactory<ILits>> solver = new Solver<ILits, DataStructureFactory<ILits>>(new FirstUIP(), percentLengthLearning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrderHeap(), new MiniSATRestarts());
        percentLengthLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniLearningHeapEZSimpLongRestarts() {
        PercentLengthLearning<ILits, DataStructureFactory<ILits>> percentLengthLearning = new PercentLengthLearning<ILits, DataStructureFactory<ILits>>(10);
        Solver<ILits, DataStructureFactory<ILits>> solver = new Solver<ILits, DataStructureFactory<ILits>>(new FirstUIP(), percentLengthLearning, new MixedDataStructureDaniel(), new SearchParams(1000), new VarOrderHeap(), new MiniSATRestarts());
        percentLengthLearning.setSolver(solver);
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newActiveLearning() {
        ActiveLearning activeLearning = new ActiveLearning();
        Solver<ILits, DataStructureFactory<ILits>> solver = new Solver<ILits, DataStructureFactory<ILits>>(new FirstUIP(), activeLearning, new MixedDataStructureDaniel(), new VarOrder(), new MiniSATRestarts());
        activeLearning.setOrder(solver.getOrder());
        activeLearning.setSolver(solver);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniSAT() {
        return SolverFactory.newMiniSAT(new MixedDataStructureDaniel());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniSATNoRestarts() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver<ILits, DataStructureFactory<ILits>> solver = new Solver<ILits, DataStructureFactory<ILits>>(new FirstUIP(), miniSATLearning, new MixedDataStructureDaniel(), new SearchParams(Integer.MAX_VALUE), new VarOrder(), new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static Solver<ILits2, DataStructureFactory<ILits2>> newMiniSAT2() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinary());
    }

    public static Solver<ILits23, DataStructureFactory<ILits23>> newMiniSAT23() {
        return SolverFactory.newMiniSAT(new MixedDataStructureWithBinaryAndTernary());
    }

    public static <L extends ILits> Solver<L, DataStructureFactory<L>> newMiniSAT(DataStructureFactory<L> dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, dataStructureFactory, new VarOrder(), new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniSATHeap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureDaniel());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniSATHeapEZSimp() {
        Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newMiniSATHeap();
        solver.setSimplifier(solver.SIMPLE_SIMPLIFICATION);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniSATHeapExpSimp() {
        Solver<ILits, DataStructureFactory<ILits>> solver = SolverFactory.newMiniSATHeap();
        solver.setSimplifier(solver.EXPENSIVE_SIMPLIFICATION);
        return solver;
    }

    public static Solver<ILits2, DataStructureFactory<ILits2>> newMiniSAT2Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinary());
    }

    public static Solver<ILits23, DataStructureFactory<ILits23>> newMiniSAT23Heap() {
        return SolverFactory.newMiniSATHeap(new MixedDataStructureWithBinaryAndTernary());
    }

    public static <L extends ILits> Solver<L, DataStructureFactory<L>> newMiniSATHeap(DataStructureFactory<L> dataStructureFactory) {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver solver = new Solver(new FirstUIP(), miniSATLearning, dataStructureFactory, new VarOrderHeap(), new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newMiniCard() {
        return SolverFactory.newMiniSAT(new CardinalityDataStructure());
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newRelsat() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver<ILits, DataStructureFactory<ILits>> solver = new Solver<ILits, DataStructureFactory<ILits>>(new DecisionUIP(), miniSATLearning, new MixedDataStructureDaniel(), new VarOrderHeap(), new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static Solver<ILits, DataStructureFactory<ILits>> newBackjumping() {
        NoLearningButHeuristics noLearningButHeuristics = new NoLearningButHeuristics();
        Solver<ILits, DataStructureFactory<ILits>> solver = new Solver<ILits, DataStructureFactory<ILits>>(new FirstUIP(), noLearningButHeuristics, new MixedDataStructureDaniel(), new VarOrderHeap(), new MiniSATRestarts());
        noLearningButHeuristics.setVarActivityListener(solver);
        return solver;
    }

    public static Solver<ILits23, DataStructureFactory<ILits23>> newMini3SAT() {
        FixedLengthLearning<ILits23, DataStructureFactory<ILits23>> fixedLengthLearning = new FixedLengthLearning<ILits23, DataStructureFactory<ILits23>>(3);
        Solver<ILits23, DataStructureFactory<ILits23>> solver = new Solver<ILits23, DataStructureFactory<ILits23>>(new FirstUIP(), fixedLengthLearning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new JWOrder(), new MiniSATRestarts());
        fixedLengthLearning.setSolver(solver);
        return solver;
    }

    public static Solver<ILits23, DataStructureFactory<ILits23>> newMini3SATb() {
        MiniSATLearning miniSATLearning = new MiniSATLearning();
        Solver<ILits23, DataStructureFactory<ILits23>> solver = new Solver<ILits23, DataStructureFactory<ILits23>>(new FirstUIP(), miniSATLearning, new MixedDataStructureWithBinaryAndTernary(), new SearchParams(Integer.MAX_VALUE), new JWOrder(), new MiniSATRestarts());
        miniSATLearning.setDataStructureFactory(solver.getDSFactory());
        miniSATLearning.setVarActivityListener(solver);
        return solver;
    }

    public static ISolver newMinOneSolver() {
        return new OptToSatAdapter(new MinOneDecorator(SolverFactory.newDefault()));
    }

    public static ISolver newDefault() {
        return SolverFactory.newMiniLearningHeapRsatExpSimpBiere();
    }

    @Override
    public ISolver defaultSolver() {
        return SolverFactory.newDefault();
    }

    public static ISolver newLight() {
        return SolverFactory.newMini3SAT();
    }

    @Override
    public ISolver lightSolver() {
        return SolverFactory.newLight();
    }

    public static ISolver newDimacsOutput() {
        return new DimacsOutputSolver();
    }
}

