/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints;

import org.sat4j.minisat.constraints.AbstractDataStructureFactory;
import org.sat4j.minisat.constraints.cnf.Clauses;
import org.sat4j.minisat.constraints.cnf.LearntHTClause;
import org.sat4j.minisat.constraints.cnf.Lits23;
import org.sat4j.minisat.constraints.cnf.OriginalHTClause;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.ILits23;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MixedDataStructureWithBinaryAndTernary
extends AbstractDataStructureFactory<ILits23> {
    private static final long serialVersionUID = 1L;

    @Override
    public Constr createClause(IVecInt iVecInt) throws ContradictionException {
        IVecInt iVecInt2 = Clauses.sanityCheck(iVecInt, this.lits, this.solver);
        if (iVecInt2 == null) {
            return null;
        }
        if (iVecInt2.size() == 2) {
            ((ILits23)this.lits).binaryClauses(iVecInt2.get(0), iVecInt2.get(1));
            return null;
        }
        if (iVecInt2.size() == 3) {
            ((ILits23)this.lits).ternaryClauses(iVecInt2.get(0), iVecInt2.get(1), iVecInt2.get(2));
            return null;
        }
        return OriginalHTClause.brandNewClause(this.solver, this.lits, iVecInt2);
    }

    @Override
    public void learnConstraint(Constr constr) {
        if (constr.size() == 2) {
            ((ILits23)this.lits).binaryClauses(constr.get(0), constr.get(1));
        } else if (constr.size() == 3) {
            ((ILits23)this.lits).ternaryClauses(constr.get(0), constr.get(1), constr.get(2));
        } else {
            super.learnConstraint(constr);
        }
    }

    @Override
    protected ILits23 createLits() {
        return new Lits23();
    }

    @Override
    public Constr createUnregisteredClause(IVecInt iVecInt) {
        return new LearntHTClause(iVecInt, (ILits)this.getVocabulary());
    }

    @Override
    protected /* synthetic */ ILits createLits() {
        return this.createLits();
    }
}

