/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.constraints.cnf.DefaultHTClause;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public abstract class HTClause
implements Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    private double activity;
    protected final int[] lits;
    protected final ILits voc;
    protected static final int HEAD = 0;
    protected final int tail;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTClause(IVecInt iVecInt, ILits iLits) {
        this.lits = new int[iVecInt.size()];
        iVecInt.moveTo(this.lits);
        if (!$assertionsDisabled && iVecInt.size() != 0) {
            throw new AssertionError();
        }
        this.voc = iLits;
        this.activity = 0.0;
        this.tail = this.lits.length - 1;
    }

    public static HTClause brandNewClause(UnitPropagationListener unitPropagationListener, ILits iLits, IVecInt iVecInt) {
        DefaultHTClause defaultHTClause = new DefaultHTClause(iVecInt, iLits);
        defaultHTClause.register();
        return defaultHTClause;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int[] nArray = this.lits;
        for (int i = 0; i < nArray.length; ++i) {
            if (!this.voc.isFalsified(nArray[i])) continue;
            iVecInt.push(LiteralsUtils.neg(nArray[i]));
        }
    }

    public void remove() {
        this.voc.attaches(LiteralsUtils.neg(this.lits[0])).remove(this);
        this.voc.attaches(LiteralsUtils.neg(this.lits[this.tail])).remove(this);
    }

    public boolean simplify() {
        for (int i = 0; i < this.lits.length; ++i) {
            if (!this.voc.isSatisfied(this.lits[i])) continue;
            return true;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        int[] nArray = this.lits;
        if (nArray[0] == LiteralsUtils.neg(n)) {
            int n3;
            for (n3 = 1; n3 < this.tail && this.voc.isFalsified(nArray[n3]); ++n3) {
            }
            if (!$assertionsDisabled && n3 > this.tail) {
                throw new AssertionError();
            }
            if (n3 == this.tail) {
                this.voc.attach(n, this);
                return unitPropagationListener.enqueue(nArray[this.tail], this);
            }
            nArray[0] = nArray[n3];
            nArray[n3] = LiteralsUtils.neg(n);
            this.voc.attach(LiteralsUtils.neg(nArray[0]), this);
            return true;
        }
        if (!$assertionsDisabled && nArray[this.tail] != LiteralsUtils.neg(n)) {
            throw new AssertionError();
        }
        for (n2 = this.tail - 1; 0 < n2 && this.voc.isFalsified(nArray[n2]); --n2) {
        }
        if (!$assertionsDisabled && 0 > n2) {
            throw new AssertionError();
        }
        if (0 == n2) {
            this.voc.attach(n, this);
            return unitPropagationListener.enqueue(nArray[0], this);
        }
        nArray[this.tail] = nArray[n2];
        nArray[n2] = LiteralsUtils.neg(n);
        this.voc.attach(LiteralsUtils.neg(nArray[this.tail]), this);
        return true;
    }

    public boolean locked() {
        return this.voc.getReason(this.lits[0]) == this || this.voc.getReason(this.lits[this.tail]) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.lits.length; ++i) {
            stringBuffer.append(Lits.toString(this.lits[i]));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(this.lits[i]));
            stringBuffer.append("]");
            stringBuffer.append(" ");
        }
        return stringBuffer.toString();
    }

    public int get(int n) {
        return this.lits[n];
    }

    public void incActivity(double d) {
        this.activity += d;
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.lits.length;
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        boolean bl;
        int[] nArray = this.lits;
        if (this.voc.isUnassigned(nArray[0])) {
            bl = unitPropagationListener.enqueue(nArray[0], this);
        } else {
            if (!$assertionsDisabled && !this.voc.isUnassigned(nArray[this.tail])) {
                throw new AssertionError();
            }
            bl = unitPropagationListener.enqueue(nArray[this.tail], this);
        }
        if (!$assertionsDisabled && !bl) {
            throw new AssertionError();
        }
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] nArray = new int[this.size()];
        System.arraycopy(this.lits, 0, nArray, 0, this.size());
        return nArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            HTClause hTClause = (HTClause)object;
            if (this.lits.length != hTClause.lits.length) {
                return false;
            }
            int[] nArray = this.lits;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                boolean bl = false;
                int[] nArray2 = hTClause.lits;
                int n3 = nArray2.length;
                for (int j = 0; j < n3; ++j) {
                    int n4 = nArray2[j];
                    if (n2 != n4) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = 0L;
        int[] nArray = this.lits;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            l += (long)n2;
        }
        return (int)l / this.lits.length;
    }

    static {
        $assertionsDisabled = !HTClause.class.desiredAssertionStatus();
    }
}

