/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.sat4j.reader.DimacsReader;
import org.sat4j.reader.ParseFormatException;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.GateTranslator;

public class ExtendedDimacsReader
extends DimacsReader {
    public static final int FALSE = 1;
    public static final int TRUE = 2;
    public static final int NOT = 3;
    public static final int AND = 4;
    public static final int NAND = 5;
    public static final int OR = 6;
    public static final int NOR = 7;
    public static final int XOR = 8;
    public static final int XNOR = 9;
    public static final int IMPLIES = 10;
    public static final int IFF = 11;
    public static final int IFTHENELSE = 12;
    public static final int ATLEAST = 13;
    public static final int ATMOST = 14;
    public static final int COUNT = 15;
    private static final long serialVersionUID = 1L;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ExtendedDimacsReader(ISolver iSolver) {
        super(new GateTranslator(iSolver));
    }

    protected void readProblemLine(LineNumberReader lineNumberReader) throws IOException, ParseFormatException {
        String string = lineNumberReader.readLine();
        if (string == null) {
            throw new ParseFormatException("premature end of file: <p noncnf ...> expected  on line " + lineNumberReader.getLineNumber());
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (!(stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("p") && stringTokenizer.hasMoreTokens() && stringTokenizer.nextToken().equals("noncnf"))) {
            throw new ParseFormatException("problem line expected (p noncnf ...) on line " + lineNumberReader.getLineNumber());
        }
        int n = Integer.parseInt(stringTokenizer.nextToken());
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        this.solver.newVar(n);
        try {
            ((GateTranslator)this.solver).gateTrue(n);
        }
        catch (ContradictionException contradictionException) {
            throw new ParseFormatException("Contradiction when asserting root variable?");
        }
        this.disableNumberOfConstraintCheck();
    }

    protected boolean handleConstr(String string, IVecInt iVecInt) throws ContradictionException {
        boolean bl = true;
        if (!$assertionsDisabled && iVecInt.size() != 0) {
            throw new AssertionError();
        }
        Scanner scanner = new Scanner(string);
        GateTranslator gateTranslator = (GateTranslator)this.solver;
        block10: while (scanner.hasNext()) {
            int n;
            int n2;
            int n3 = scanner.nextInt();
            if (!$assertionsDisabled && n3 <= 0) {
                throw new AssertionError();
            }
            int n4 = scanner.nextInt();
            if (!$assertionsDisabled && n4 == 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && n4 != -1 && n3 < 13) {
                throw new AssertionError();
            }
            for (n2 = 0; n2 < n4; ++n2) {
                scanner.nextInt();
            }
            n2 = scanner.nextInt();
            while ((n = scanner.nextInt()) != 0) {
                iVecInt.push(n);
            }
            switch (n3) {
                case 1: {
                    if (!$assertionsDisabled && iVecInt.size() != 0) {
                        throw new AssertionError();
                    }
                    gateTranslator.gateFalse(n2);
                    continue block10;
                }
                case 2: {
                    if (!$assertionsDisabled && iVecInt.size() != 0) {
                        throw new AssertionError();
                    }
                    gateTranslator.gateTrue(n2);
                    continue block10;
                }
                case 6: {
                    gateTranslator.or(n2, iVecInt);
                    continue block10;
                }
                case 3: {
                    if (!$assertionsDisabled && iVecInt.size() != 1) {
                        throw new AssertionError();
                    }
                    gateTranslator.not(n2, iVecInt.get(0));
                    continue block10;
                }
                case 4: {
                    gateTranslator.and(n2, iVecInt);
                    continue block10;
                }
                case 8: {
                    gateTranslator.xor(n2, iVecInt);
                    continue block10;
                }
                case 11: {
                    gateTranslator.iff(n2, iVecInt);
                    continue block10;
                }
                case 12: {
                    if (!$assertionsDisabled && iVecInt.size() != 3) {
                        throw new AssertionError();
                    }
                    gateTranslator.ite(n2, iVecInt.get(0), iVecInt.get(1), iVecInt.get(2));
                    continue block10;
                }
            }
            throw new UnsupportedOperationException("Gate type " + n3 + " not handled yet");
        }
        iVecInt.clear();
        return bl;
    }

    static {
        $assertionsDisabled = !ExtendedDimacsReader.class.desiredAssertionStatus();
    }
}

