/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.IVisualizationTool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTracing
extends SearchListenerAdapter<ISolverService> {
    private static final long serialVersionUID = 1L;
    private int counter;
    private final IVisualizationTool positiveVisu;
    private final IVisualizationTool negativeVisu;
    private final IVisualizationTool restartVisu;
    private final IVisualizationTool cleanVisu;
    private int nVar;

    public DecisionTracing(IVisualizationTool iVisualizationTool, IVisualizationTool iVisualizationTool2, IVisualizationTool iVisualizationTool3, IVisualizationTool iVisualizationTool4) {
        this.positiveVisu = iVisualizationTool;
        this.negativeVisu = iVisualizationTool2;
        this.restartVisu = iVisualizationTool3;
        this.cleanVisu = iVisualizationTool4;
        this.counter = 1;
    }

    @Override
    public void assuming(int n) {
        if (n > 0) {
            this.positiveVisu.addPoint(this.counter, n);
            this.negativeVisu.addInvisiblePoint(this.counter, 0.0);
        } else {
            this.negativeVisu.addPoint(this.counter, -n);
            this.positiveVisu.addInvisiblePoint(this.counter, 0.0);
        }
        this.restartVisu.addInvisiblePoint(this.counter, 0.0);
        this.cleanVisu.addInvisiblePoint(this.counter, 0.0);
        ++this.counter;
    }

    @Override
    public void restarting() {
        this.restartVisu.addPoint(this.counter, this.nVar);
        this.cleanVisu.addPoint(this.counter, 0.0);
        this.positiveVisu.addInvisiblePoint(this.counter, 0.0);
        this.negativeVisu.addInvisiblePoint(this.counter, 0.0);
    }

    @Override
    public void end(Lbool lbool) {
        this.positiveVisu.end();
        this.negativeVisu.end();
        this.restartVisu.end();
        this.cleanVisu.end();
    }

    @Override
    public void start() {
        this.counter = 1;
    }

    @Override
    public void init(ISolverService iSolverService) {
        this.nVar = iSolverService.nVars();
        this.positiveVisu.init();
        this.negativeVisu.init();
        this.restartVisu.init();
        this.cleanVisu.init();
    }

    @Override
    public void cleaning() {
        this.restartVisu.addPoint(this.counter, 0.0);
        this.cleanVisu.addPoint(this.counter, this.nVar);
        this.positiveVisu.addInvisiblePoint(this.counter, 0.0);
        this.negativeVisu.addInvisiblePoint(this.counter, 0.0);
    }
}

