/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.constraints.cnf;

import java.io.Serializable;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.minisat.constraints.cnf.Lits;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.Propagatable;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.specs.IVecInt;

public abstract class HTClause
implements Propagatable,
Constr,
Serializable {
    private static final long serialVersionUID = 1L;
    protected double activity;
    protected final int[] middleLits;
    protected final ILits voc;
    protected int head;
    protected int tail;

    public HTClause(IVecInt iVecInt, ILits iLits) {
        assert (iVecInt.size() > 1);
        this.head = iVecInt.get(0);
        this.tail = iVecInt.last();
        int n = iVecInt.size() - 2;
        assert (n > 0);
        this.middleLits = new int[n];
        System.arraycopy(iVecInt.toArray(), 1, this.middleLits, 0, n);
        iVecInt.clear();
        assert (iVecInt.size() == 0);
        this.voc = iLits;
        this.activity = 0.0;
    }

    public void calcReason(int n, IVecInt iVecInt) {
        int[] nArray;
        if (this.voc.isFalsified(this.head)) {
            iVecInt.push(LiteralsUtils.neg(this.head));
        }
        for (int n2 : nArray = this.middleLits) {
            if (!this.voc.isFalsified(n2)) continue;
            iVecInt.push(LiteralsUtils.neg(n2));
        }
        if (this.voc.isFalsified(this.tail)) {
            iVecInt.push(LiteralsUtils.neg(this.tail));
        }
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        this.voc.watches(LiteralsUtils.neg(this.head)).remove(this);
        this.voc.watches(LiteralsUtils.neg(this.tail)).remove(this);
    }

    public boolean simplify() {
        if (this.voc.isSatisfied(this.head) || this.voc.isSatisfied(this.tail)) {
            return true;
        }
        for (int n : this.middleLits) {
            if (!this.voc.isSatisfied(n)) continue;
            return true;
        }
        return false;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        if (this.head == LiteralsUtils.neg(n)) {
            int n3;
            int[] nArray = this.middleLits;
            for (n3 = 0; n3 < nArray.length && this.voc.isFalsified(nArray[n3]); ++n3) {
            }
            assert (n3 <= nArray.length);
            if (n3 == nArray.length) {
                this.voc.watch(n, this);
                return unitPropagationListener.enqueue(this.tail, this);
            }
            this.head = nArray[n3];
            nArray[n3] = LiteralsUtils.neg(n);
            this.voc.watch(LiteralsUtils.neg(this.head), this);
            return true;
        }
        assert (this.tail == LiteralsUtils.neg(n));
        int[] nArray = this.middleLits;
        for (n2 = nArray.length - 1; n2 >= 0 && this.voc.isFalsified(nArray[n2]); --n2) {
        }
        assert (-1 <= n2);
        if (-1 == n2) {
            this.voc.watch(n, this);
            return unitPropagationListener.enqueue(this.head, this);
        }
        this.tail = nArray[n2];
        nArray[n2] = LiteralsUtils.neg(n);
        this.voc.watch(LiteralsUtils.neg(this.tail), this);
        return true;
    }

    public boolean locked() {
        return this.voc.getReason(this.head) == this || this.voc.getReason(this.tail) == this;
    }

    public double getActivity() {
        return this.activity;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Lits.toString(this.head));
        stringBuffer.append("[");
        stringBuffer.append(this.voc.valueToString(this.head));
        stringBuffer.append("]");
        stringBuffer.append(" ");
        for (int n : this.middleLits) {
            stringBuffer.append(Lits.toString(n));
            stringBuffer.append("[");
            stringBuffer.append(this.voc.valueToString(n));
            stringBuffer.append("]");
            stringBuffer.append(" ");
        }
        stringBuffer.append(Lits.toString(this.tail));
        stringBuffer.append("[");
        stringBuffer.append(this.voc.valueToString(this.tail));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int get(int n) {
        if (n == 0) {
            return this.head;
        }
        if (n == this.middleLits.length + 1) {
            return this.tail;
        }
        return this.middleLits[n - 1];
    }

    public void rescaleBy(double d) {
        this.activity *= d;
    }

    public int size() {
        return this.middleLits.length + 2;
    }

    public void assertConstraint(UnitPropagationListener unitPropagationListener) {
        assert (this.voc.isUnassigned(this.head));
        boolean bl = unitPropagationListener.enqueue(this.head, this);
        assert (bl);
    }

    public ILits getVocabulary() {
        return this.voc;
    }

    public int[] getLits() {
        int[] nArray = new int[this.size()];
        System.arraycopy(this.middleLits, 0, nArray, 1, this.middleLits.length);
        nArray[0] = this.head;
        nArray[nArray.length - 1] = this.tail;
        return nArray;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            HTClause hTClause = (HTClause)object;
            if (hTClause.head != this.head || hTClause.tail != this.tail) {
                return false;
            }
            if (this.middleLits.length != hTClause.middleLits.length) {
                return false;
            }
            for (int n : this.middleLits) {
                boolean bl = false;
                for (int n2 : hTClause.middleLits) {
                    if (n != n2) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                return false;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        long l = this.head + this.tail;
        for (int n : this.middleLits) {
            l += (long)n;
        }
        return (int)l / this.middleLits.length;
    }

    public boolean canBePropagatedMultipleTimes() {
        return false;
    }

    public Constr toConstraint() {
        return this;
    }

    public void calcReasonOnTheFly(int n, IVecInt iVecInt, IVecInt iVecInt2) {
        this.calcReason(n, iVecInt2);
    }
}

