/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.sat4j.core.ASolverFactory;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMUSSolutionListener
implements SolutionFoundListener {
    private List<IVecInt> clauses = new ArrayList<IVecInt>();
    private String explain;
    private final ASolverFactory<? extends ISolver> factory;

    public CheckMUSSolutionListener(ASolverFactory<? extends ISolver> aSolverFactory) {
        this.factory = aSolverFactory;
    }

    public void addOriginalClause(IVecInt iVecInt) {
        VecInt vecInt = new VecInt(iVecInt.size());
        if (this.clauses == null) {
            this.clauses = new ArrayList<IVecInt>();
        }
        iVecInt.copyTo(vecInt);
        this.clauses.add(vecInt);
    }

    public boolean checkThatItIsAMUS(IVecInt iVecInt) {
        int n;
        boolean bl = false;
        ISolver iSolver = this.factory.defaultSolver();
        try {
            for (n = 0; n < iVecInt.size(); ++n) {
                iSolver.addClause(this.clauses.get(iVecInt.get(n) - 1));
            }
            boolean bl2 = bl = !iSolver.isSatisfiable();
            if (!bl) {
                this.explain = "The set of clauses in the MUS is SAT : " + Arrays.toString(iSolver.model());
                return bl;
            }
        }
        catch (ContradictionException contradictionException) {
            bl = true;
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        try {
            for (n = 0; n < iVecInt.size(); ++n) {
                iSolver = this.factory.defaultSolver();
                for (int i = 0; i < iVecInt.size(); ++i) {
                    if (i == n) continue;
                    iSolver.addClause(this.clauses.get(iVecInt.get(i) - 1));
                }
                boolean bl3 = bl = bl && iSolver.isSatisfiable();
                if (bl) continue;
                this.explain = "The subset of clauses in the MUS not containing clause " + (n + 1) + " is SAT : " + Arrays.toString(iSolver.model());
                return bl;
            }
        }
        catch (ContradictionException contradictionException) {
            bl = false;
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        return bl;
    }

    @Override
    public void onSolutionFound(int[] nArray) {
    }

    @Override
    public void onSolutionFound(IVecInt iVecInt) {
        if (this.checkThatItIsAMUS(iVecInt)) {
            System.out.println(iVecInt + " is a MUS");
        } else {
            System.out.println(iVecInt + " is not a MUS \n" + this.explain);
        }
    }

    @Override
    public void onUnsatTermination() {
    }
}

