/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.core.Counter;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.specs.SearchListener;
import org.sat4j.specs.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatisticsSolver
implements ISolver {
    private static final String NOT_IMPLEMENTED_YET = "Not implemented yet!";
    private static final String THAT_SOLVER_ONLY_COMPUTE_STATISTICS = "That solver only compute statistics";
    private static final long serialVersionUID = 1L;
    private int expectedNumberOfConstraints;
    private int nbvars;
    private IVecInt[] sizeoccurrences;
    private int allpositive;
    private int allnegative;
    private int horn;
    private int dualhorn;
    private final Map<Integer, Counter> sizes = new HashMap<Integer, Counter>();

    @Override
    public int[] model() {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean model(int n) {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int[] primeImplicant() {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean primeImplicant(int n) {
        throw new UnsupportedOperationException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable() throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt, boolean bl) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable(boolean bl) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public boolean isSatisfiable(IVecInt iVecInt) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int[] findModel() throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int[] findModel(IVecInt iVecInt) throws TimeoutException {
        throw new TimeoutException(THAT_SOLVER_ONLY_COMPUTE_STATISTICS);
    }

    @Override
    public int nConstraints() {
        return this.expectedNumberOfConstraints;
    }

    @Override
    public int newVar(int n) {
        this.nbvars = n;
        this.sizeoccurrences = new IVecInt[n + 1 << 1];
        return n;
    }

    @Override
    public int nVars() {
        return this.nbvars;
    }

    @Override
    @Deprecated
    public void printInfos(PrintWriter printWriter, String string) {
    }

    @Override
    public void printInfos(PrintWriter printWriter) {
    }

    @Override
    @Deprecated
    public int newVar() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int nextFreeVarId(boolean bl) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void registerLiteral(int n) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setExpectedNumberOfClauses(int n) {
        this.expectedNumberOfConstraints = n;
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        int n = iVecInt.size();
        Counter counter = this.sizes.get(n);
        if (counter == null) {
            counter = new Counter(0);
            this.sizes.put(n, counter);
        }
        counter.inc();
        int n2 = 0;
        int n3 = 0;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            int n4 = iteratorInt.next();
            if (n4 > 0) {
                ++n2;
            } else {
                ++n3;
            }
            int n5 = LiteralsUtils.toInternal(n4);
            IVecInt iVecInt2 = this.sizeoccurrences[n5];
            if (iVecInt2 == null) {
                this.sizeoccurrences[n5] = iVecInt2 = new VecInt();
            }
            iVecInt2.push(n);
        }
        if (n3 == 0) {
            ++this.allpositive;
        } else if (n2 == 0) {
            ++this.allnegative;
        } else if (n2 == 1) {
            ++this.horn;
        } else if (n3 == 1) {
            ++this.dualhorn;
        }
        return null;
    }

    @Override
    public IConstr addBlockingClause(IVecInt iVecInt) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public boolean removeConstr(IConstr iConstr) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public boolean removeSubsumedConstr(IConstr iConstr) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void addAllClauses(IVec<IVecInt> iVec) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IConstr addExactly(IVecInt iVecInt, int n) throws ContradictionException {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setTimeout(int n) {
    }

    @Override
    public void setTimeoutOnConflicts(int n) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setTimeoutMs(long l) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int getTimeout() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public long getTimeoutMs() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void expireTimeout() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void reset() {
    }

    @Override
    @Deprecated
    public void printStat(PrintStream printStream, String string) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    @Deprecated
    public void printStat(PrintWriter printWriter, String string) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void printStat(PrintWriter printWriter) {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MIN_VALUE;
        int n7 = 0;
        int n8 = Integer.MAX_VALUE;
        int n9 = Integer.MIN_VALUE;
        int n10 = 0;
        if (this.sizeoccurrences == null) {
            return;
        }
        int n11 = this.sizeoccurrences.length - 1;
        for (n = 1; n < n11; n += 2) {
            int n12 = 0;
            boolean bl = false;
            for (int i = 0; i < 2; ++i) {
                IVecInt iVecInt = this.sizeoccurrences[n + i];
                if (iVecInt == null) {
                    bl = true;
                    continue;
                }
                ++n3;
                int n13 = iVecInt.size();
                n12 += n13;
                if (n8 > n13) {
                    n8 = n13;
                }
                if (n13 > n9) {
                    n9 = n13;
                }
                n10 += n13;
            }
            if (n12 <= 0) continue;
            if (bl) {
                ++n4;
            }
            ++n2;
            if (n5 > n12) {
                n5 = n12;
            }
            if (n12 > n6) {
                n6 = n12;
            }
            n7 += n12;
        }
        System.out.println("c Distribution of constraints size:");
        n = 0;
        for (Map.Entry<Integer, Counter> entry : this.sizes.entrySet()) {
            System.out.printf("c %d => %d%n", entry.getKey(), entry.getValue().getValue());
            n += entry.getValue().getValue();
        }
        System.out.printf("c Real number of variables, literals, number of clauses, #pureliterals, ", new Object[0]);
        System.out.printf("variable occurrences (min/max/avg) ", new Object[0]);
        System.out.printf("literals occurrences (min/max/avg) ", new Object[0]);
        System.out.println("Specific clauses: #positive  #negative #horn  #dualhorn #remaining");
        System.out.printf("%d %d %d %d %d %d %d %d %d %d ", n2, n3, n, n4, n5, n6, n7 / n2, n8, n9, n10 / n3);
        System.out.printf("%d %d %d %d %d%n", this.allpositive, this.allnegative, this.horn, this.dualhorn, n - this.allpositive - this.allnegative - this.horn - this.dualhorn);
    }

    @Override
    public Map<String, Number> getStat() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public String toString(String string) {
        return string + "Statistics about the benchmarks";
    }

    @Override
    public void clearLearntClauses() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setDBSimplificationAllowed(boolean bl) {
    }

    @Override
    public boolean isDBSimplificationAllowed() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public <S extends ISolverService> void setSearchListener(SearchListener<S> searchListener) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public <S extends ISolverService> SearchListener<S> getSearchListener() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public boolean isVerbose() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setVerbose(boolean bl) {
    }

    @Override
    public void setLogPrefix(String string) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public String getLogPrefix() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public IVecInt unsatExplanation() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int[] modelWithInternalVariables() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public int realNumberOfVariables() {
        return this.nbvars;
    }

    @Override
    public boolean isSolverKeptHot() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public void setKeepSolverHot(boolean bl) {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }

    @Override
    public ISolver getSolvingEngine() {
        throw new UnsupportedOperationException(NOT_IMPLEMENTED_YET);
    }
}

