/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IGroupSolver;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.AbstractClauseSelectorSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupClauseSelectorSolver<T extends ISolver>
extends AbstractClauseSelectorSolver<T>
implements IGroupSolver {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Integer> varToHighLevel = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> highLevelToVar = new HashMap<Integer, Integer>();

    public GroupClauseSelectorSolver(T t) {
        super(t);
    }

    public IConstr addControlableClause(IVecInt iVecInt, int n) throws ContradictionException {
        if (n == 0) {
            return super.addClause(iVecInt);
        }
        Integer n2 = this.highLevelToVar.get(n);
        if (n2 == null) {
            n2 = this.createNewVar(iVecInt);
            this.highLevelToVar.put(n, n2);
            this.varToHighLevel.put(n2, n);
        }
        iVecInt.push(n2);
        return super.addClause(iVecInt);
    }

    public IConstr addNonControlableClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    @Override
    public IConstr addClause(IVecInt iVecInt, int n) throws ContradictionException {
        return this.addControlableClause(iVecInt, n);
    }

    @Override
    public Collection<Integer> getAddedVars() {
        return this.varToHighLevel.keySet();
    }

    @Override
    public int[] model() {
        int[] nArray = super.modelWithInternalVariables();
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length - this.varToHighLevel.size()];
        int n = 0;
        int[] nArray3 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray3[n3];
            if (this.varToHighLevel.get(Math.abs(n4)) == null) {
                nArray2[n++] = n4;
            }
            ++n3;
        }
        return nArray2;
    }

    public Map<Integer, Integer> getVarToHighLevel() {
        return this.varToHighLevel;
    }
}

