/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.sat4j.core.LiteralsUtils;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolverService;
import org.sat4j.specs.Lbool;
import org.sat4j.tools.SearchListenerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RupSearchListener<S extends ISolverService>
extends SearchListenerAdapter<S> {
    private static final long serialVersionUID = 1L;
    private PrintStream out;
    private final File file;

    public RupSearchListener(String string) {
        this.file = new File(string);
    }

    @Override
    public void init(S s) {
        try {
            this.out = new PrintStream(new FileOutputStream(this.file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.out = System.out;
        }
    }

    @Override
    public void end(Lbool lbool) {
        if (lbool == Lbool.FALSE) {
            this.out.println("0");
            this.out.close();
        } else {
            this.out.close();
            this.file.delete();
        }
    }

    @Override
    public void learn(IConstr iConstr) {
        int n = 0;
        while (n < iConstr.size()) {
            this.out.print(LiteralsUtils.toDimacs(iConstr.get(n)));
            this.out.print(" ");
            ++n;
        }
        this.out.println("0");
    }

    @Override
    public void learnUnit(int n) {
        this.out.print(n);
        this.out.println(" 0");
    }
}

