/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools.encoding;

import java.io.Serializable;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;

public abstract class EncodingStrategyAdapter
implements Serializable {
    private static final long serialVersionUID = 1L;

    public IConstr addAtLeast(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        int n2 = iVecInt.size();
        VecInt vecInt = new VecInt(n2);
        int n3 = 0;
        while (n3 < n2) {
            vecInt.push(-iVecInt.get(n3));
            ++n3;
        }
        return this.addAtMost(iSolver, vecInt, n2 - n);
    }

    public IConstr addAtLeastOne(ISolver iSolver, IVecInt iVecInt) throws ContradictionException {
        return iSolver.addClause(iVecInt);
    }

    public IConstr addAtMost(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        return iSolver.addAtMost(iVecInt, n);
    }

    public IConstr addAtMostOne(ISolver iSolver, IVecInt iVecInt) throws ContradictionException {
        return this.addAtMost(iSolver, iVecInt, 1);
    }

    public IConstr addExactly(ISolver iSolver, IVecInt iVecInt, int n) throws ContradictionException {
        return iSolver.addExactly(iVecInt, n);
    }

    public IConstr addExactlyOne(ISolver iSolver, IVecInt iVecInt) throws ContradictionException {
        return this.addExactly(iSolver, iVecInt, 1);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

