/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j;

import java.io.PrintWriter;
import org.sat4j.ExitCode;
import org.sat4j.ILogAble;
import org.sat4j.core.Vec;
import org.sat4j.reader.Reader;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IProblem;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.Backbone;
import org.sat4j.tools.LexicoDecorator;
import org.sat4j.tools.SolutionFoundListener;

public interface ILauncherMode
extends SolutionFoundListener {
    public static final String SOLUTION_PREFIX = "v ";
    public static final String ANSWER_PREFIX = "s ";
    public static final String CURRENT_OPTIMUM_VALUE_PREFIX = "o ";
    public static final ILauncherMode DECISION = new ILauncherMode(){
        private ExitCode exitCode = ExitCode.UNKNOWN;
        private int nbSolutionFound;
        private PrintWriter out;
        private ISolver aSolver;
        private Reader reader;

        public void displayResult(ISolver iSolver, IProblem iProblem, ILogAble iLogAble, PrintWriter printWriter, Reader reader, long l, boolean bl) {
            if (iSolver != null) {
                printWriter.flush();
                double d = (double)(System.currentTimeMillis() - l) / 1000.0;
                iSolver.printStat(printWriter);
                iSolver.printInfos(printWriter);
                printWriter.println(ILauncherMode.ANSWER_PREFIX + this.exitCode);
                if (this.exitCode == ExitCode.SATISFIABLE) {
                    long l2;
                    int[] nArray = iSolver.model();
                    if (System.getProperty("prime") != null) {
                        int n = nArray.length;
                        iLogAble.log("returning a prime implicant ...");
                        long l3 = System.currentTimeMillis();
                        nArray = iSolver.primeImplicant();
                        l2 = System.currentTimeMillis();
                        iLogAble.log("removed " + (n - nArray.length) + " literals");
                        iLogAble.log("pi computation time: " + (l2 - l3) + " ms");
                    }
                    if (System.getProperty("backbone") != null) {
                        iLogAble.log("computing the backbone of the formula ...");
                        long l4 = System.currentTimeMillis();
                        nArray = iSolver.primeImplicant();
                        try {
                            IVecInt iVecInt = Backbone.compute(iSolver, nArray);
                            l2 = System.currentTimeMillis();
                            printWriter.print(iSolver.getLogPrefix());
                            reader.decode(iVecInt.toArray(), printWriter);
                            printWriter.println();
                            iLogAble.log("backbone computation time: " + (l2 - l4) + " ms");
                        }
                        catch (TimeoutException timeoutException) {
                            iLogAble.log("timeout, cannot compute the backbone.");
                        }
                    }
                    if (this.nbSolutionFound > 1) {
                        iLogAble.log("Found " + this.nbSolutionFound + " solutions");
                    }
                    printWriter.print(ILauncherMode.SOLUTION_PREFIX);
                    reader.decode(nArray, printWriter);
                    printWriter.println();
                }
                iLogAble.log("Total wall clock time (in seconds) : " + d);
            }
        }

        public void solve(IProblem iProblem, Reader reader, ILogAble iLogAble, PrintWriter printWriter, long l) {
            this.exitCode = ExitCode.UNKNOWN;
            this.out = printWriter;
            this.aSolver = (ISolver)iProblem;
            this.reader = reader;
            this.nbSolutionFound = 0;
            try {
                if (iProblem.isSatisfiable()) {
                    this.exitCode = ExitCode.SATISFIABLE;
                } else if (this.exitCode == ExitCode.UNKNOWN) {
                    this.exitCode = ExitCode.UNSATISFIABLE;
                }
            }
            catch (TimeoutException timeoutException) {
                iLogAble.log("timeout");
            }
        }

        public void setIncomplete(boolean bl) {
        }

        public ExitCode getCurrentExitCode() {
            return this.exitCode;
        }

        public void onSolutionFound(int[] nArray) {
            ++this.nbSolutionFound;
            this.exitCode = ExitCode.SATISFIABLE;
            if (this.aSolver.isVerbose()) {
                this.out.printf("c Found solution #%d\n", this.nbSolutionFound);
                this.out.print(ILauncherMode.SOLUTION_PREFIX);
                this.reader.decode(nArray, this.out);
                this.out.println();
            } else {
                this.out.printf("\rc Found solution #%d", this.nbSolutionFound);
            }
        }

        public void onSolutionFound(IVecInt iVecInt) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }
    };
    public static final ILauncherMode OPTIMIZATION = new ILauncherMode(){
        private ExitCode exitCode = ExitCode.UNKNOWN;
        private boolean isIncomplete = false;

        public void setIncomplete(boolean bl) {
            this.isIncomplete = bl;
        }

        public void displayResult(ISolver iSolver, IProblem iProblem, ILogAble iLogAble, PrintWriter printWriter, Reader reader, long l, boolean bl) {
            if (iSolver == null) {
                return;
            }
            System.out.flush();
            printWriter.flush();
            iSolver.printStat(printWriter);
            iSolver.printInfos(printWriter);
            printWriter.println(ILauncherMode.ANSWER_PREFIX + this.exitCode);
            if (this.exitCode == ExitCode.SATISFIABLE || this.exitCode == ExitCode.OPTIMUM_FOUND || this.isIncomplete && this.exitCode == ExitCode.UPPER_BOUND) {
                IOptimizationProblem iOptimizationProblem;
                if (bl) {
                    printWriter.print(ILauncherMode.SOLUTION_PREFIX);
                    reader.decode(iProblem.model(), printWriter);
                    printWriter.println();
                }
                if (!(iOptimizationProblem = (IOptimizationProblem)iProblem).hasNoObjectiveFunction()) {
                    String string;
                    if (iOptimizationProblem instanceof LexicoDecorator) {
                        Vec<Number> vec = new Vec<Number>();
                        LexicoDecorator lexicoDecorator = (LexicoDecorator)iOptimizationProblem;
                        for (int i = 0; i < lexicoDecorator.numberOfCriteria(); ++i) {
                            vec.push(lexicoDecorator.getObjectiveValue(i));
                        }
                        string = ((Object)vec).toString();
                    } else {
                        string = iOptimizationProblem.getObjectiveValue().toString();
                    }
                    iLogAble.log("objective function=" + string);
                }
            }
            iLogAble.log("Total wall clock time (in seconds): " + (double)(System.currentTimeMillis() - l) / 1000.0);
        }

        public void solve(IProblem iProblem, Reader reader, ILogAble iLogAble, PrintWriter printWriter, long l) {
            boolean bl = false;
            IOptimizationProblem iOptimizationProblem = (IOptimizationProblem)iProblem;
            this.exitCode = ExitCode.UNKNOWN;
            try {
                while (iOptimizationProblem.admitABetterSolution()) {
                    if (!bl) {
                        if (iOptimizationProblem.nonOptimalMeansSatisfiable()) {
                            iLogAble.log("SATISFIABLE");
                            this.exitCode = ExitCode.SATISFIABLE;
                            if (iOptimizationProblem.hasNoObjectiveFunction()) {
                                return;
                            }
                        } else if (this.isIncomplete) {
                            this.exitCode = ExitCode.UPPER_BOUND;
                        }
                        bl = true;
                        iLogAble.log("OPTIMIZING...");
                    }
                    iLogAble.log("Got one! Elapsed wall clock time (in seconds):" + (double)(System.currentTimeMillis() - l) / 1000.0);
                    printWriter.println(ILauncherMode.CURRENT_OPTIMUM_VALUE_PREFIX + iOptimizationProblem.getObjectiveValue());
                    iOptimizationProblem.discardCurrentSolution();
                }
                this.exitCode = bl ? ExitCode.OPTIMUM_FOUND : ExitCode.UNSATISFIABLE;
            }
            catch (ContradictionException contradictionException) {
                assert (bl);
                this.exitCode = ExitCode.OPTIMUM_FOUND;
            }
            catch (TimeoutException timeoutException) {
                iLogAble.log("timeout");
            }
        }

        public ExitCode getCurrentExitCode() {
            return this.exitCode;
        }

        public void onSolutionFound(int[] nArray) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }

        public void onSolutionFound(IVecInt iVecInt) {
            throw new UnsupportedOperationException("Not implemented yet!");
        }
    };

    public void displayResult(ISolver var1, IProblem var2, ILogAble var3, PrintWriter var4, Reader var5, long var6, boolean var8);

    public void solve(IProblem var1, Reader var2, ILogAble var3, PrintWriter var4, long var5);

    public void setIncomplete(boolean var1);

    public ExitCode getCurrentExitCode();
}

