/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp;

import org.sat4j.AbstractLauncher;
import org.sat4j.csp.SolverFactory;
import org.sat4j.reader.CSPExtSupportReader;
import org.sat4j.reader.Reader;
import org.sat4j.reader.XMLCSPReader;
import org.sat4j.specs.ISolver;

public class CSPLauncher
extends AbstractLauncher {
    private static final long serialVersionUID = 1L;

    protected ISolver configureSolver(String[] stringArray) {
        ISolver iSolver = stringArray.length == 2 ? SolverFactory.instance().createSolverByName(stringArray[0]) : SolverFactory.newDefault();
        this.log(iSolver.toString("c "));
        return iSolver;
    }

    protected Reader createReader(ISolver iSolver, String string) {
        Reader reader;
        boolean bl;
        boolean bl2 = bl = System.getProperty("allDiffCards") != null;
        if (string.endsWith(".txt")) {
            reader = new CSPExtSupportReader(iSolver, bl);
        } else {
            assert (string.endsWith(".xml"));
            reader = new XMLCSPReader(iSolver, bl);
        }
        if (System.getProperty("verbose") != null) {
            this.log("verbose mode on");
            reader.setVerbosity(true);
            iSolver.setVerbose(true);
        } else {
            iSolver.setVerbose(false);
        }
        return reader;
    }

    public static void main(String[] stringArray) {
        CSPLauncher cSPLauncher = new CSPLauncher();
        if (stringArray.length > 2 || stringArray.length == 0) {
            ((AbstractLauncher)cSPLauncher).usage();
            return;
        }
        try {
            cSPLauncher.run(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            cSPLauncher.log(">>>> " + illegalArgumentException.getMessage() + " <<<<");
        }
    }

    public void displayLicense() {
        super.displayLicense();
        this.log("That software uses the Rhino library from the Mozilla project.");
    }

    public void usage() {
        System.out.println("Please provide a CSP instance file!");
    }

    protected String getInstanceName(String[] stringArray) {
        if (stringArray.length == 1) {
            return stringArray[0];
        }
        return stringArray[1];
    }
}

