/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.csp.xml;

import org.sat4j.csp.xml.CSPFormatException;
import org.sat4j.csp.xml.Element;
import org.sat4j.csp.xml.ICSPCallback;
import org.sat4j.csp.xml.InstanceParser;
import org.xml.sax.Attributes;

class Parameters
extends Element {
    private StringBuilder allParameters;
    private InstanceParser ip;

    public Parameters(ICSPCallback iCSPCallback, String string, InstanceParser instanceParser) {
        super(iCSPCallback, string);
        this.ip = instanceParser;
    }

    public void startElement(Attributes attributes) {
        this.allParameters = new StringBuilder();
    }

    public void characters(String string) {
        this.allParameters.append(string);
    }

    public void endElement() {
        if (this.ip.getParentElement().tagName().equals("constraint")) {
            this.effectiveParameters();
        } else {
            this.formalParameters();
        }
    }

    private void formalParameters() {
        String[] stringArray = this.allParameters.toString().trim().split("\\s+");
        for (int i = 0; i < stringArray.length && !stringArray[i].equals(""); ++i) {
            String string = stringArray[i];
            if (!string.equals("int")) {
                throw new CSPFormatException(string + " type for parameters not supported");
            }
            if (++i == stringArray.length || stringArray[i].equals("")) {
                throw new CSPFormatException("a parameter name is missing.");
            }
            String string2 = stringArray[i];
            this.getCB().addFormalParameter(string2, string);
        }
    }

    private void effectiveParameters() {
        String[] stringArray;
        for (String string : stringArray = this.allParameters.toString().trim().split("\\s+")) {
            if (string.equals("")) continue;
            try {
                this.getCB().addEffectiveParameter(Integer.parseInt(string));
            }
            catch (NumberFormatException numberFormatException) {
                this.getCB().addEffectiveParameter(string);
            }
        }
    }
}

