/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.minisat.restarts;

import org.sat4j.minisat.core.CircularBuffer;
import org.sat4j.minisat.core.Constr;
import org.sat4j.minisat.core.RestartStrategy;
import org.sat4j.minisat.core.SearchParams;
import org.sat4j.minisat.core.SolverStats;

public class Glucose21Restarts
implements RestartStrategy {
    private static final long serialVersionUID = 1L;
    private final CircularBuffer bufferLBD = new CircularBuffer(50);
    private final CircularBuffer bufferTrail = new CircularBuffer(5000);
    private long sumOfAllLBD = 0L;
    private final SolverStats stats;
    private SearchParams params;

    public Glucose21Restarts(SolverStats solverStats) {
        this.stats = solverStats;
    }

    public void reset() {
    }

    public void newConflict() {
    }

    public void newLearnedClause(Constr constr, int n) {
        int n2 = (int)constr.getActivity();
        this.bufferLBD.push(n2);
        this.sumOfAllLBD += (long)n2;
        this.bufferTrail.push(n);
    }

    public void init(SearchParams searchParams) {
        this.params = searchParams;
    }

    public long nextRestartNumberOfConflict() {
        return 0L;
    }

    public boolean shouldRestart() {
        return this.bufferLBD.isFull() && (double)this.bufferLBD.average() * 0.8 > (double)(this.sumOfAllLBD / this.stats.conflicts);
    }

    public void onRestart() {
        this.bufferLBD.clear();
    }

    public void onBackjumpToRootLevel() {
    }

    public SearchParams getSearchParams() {
        return this.params;
    }

    public String toString() {
        return "Glucose 2.1 dynamic restart strategy";
    }
}

