/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.constraints.pb;

import java.math.BigInteger;
import org.sat4j.minisat.core.ILits;
import org.sat4j.minisat.core.UnitPropagationListener;
import org.sat4j.pb.constraints.pb.IDataStructurePB;
import org.sat4j.pb.constraints.pb.WatchPbLongCP;
import org.sat4j.specs.ContradictionException;

public class MinWatchPbLongCP
extends WatchPbLongCP {
    private static final long serialVersionUID = 1L;
    protected long watchCumul = 0L;
    protected boolean[] watched;
    protected int[] watching;
    protected int watchingCount = 0;

    protected MinWatchPbLongCP(ILits iLits, IDataStructurePB iDataStructurePB) {
        super(iDataStructurePB);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected MinWatchPbLongCP(ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) {
        super(nArray, bigIntegerArray, bigInteger, bigInteger2);
        this.voc = iLits;
        this.watching = new int[this.coefs.length];
        this.watched = new boolean[this.coefs.length];
        this.activity = 0.0;
        this.watchCumul = 0L;
        this.watchingCount = 0;
    }

    protected void computeWatches() throws ContradictionException {
        assert (this.watchCumul == 0L);
        assert (this.watchingCount == 0);
        for (int i = 0; i < this.lits.length && this.watchCumul - this.coefs[0] < this.degree; ++i) {
            if (this.voc.isFalsified(this.lits[i])) continue;
            this.voc.watch(this.lits[i] ^ 1, this);
            this.watching[this.watchingCount++] = i;
            this.watched[i] = true;
            this.watchCumul += this.coefs[i];
        }
        if (this.learnt) {
            this.watchMoreForLearntConstraint();
        }
        if (this.watchCumul < this.degree) {
            throw new ContradictionException("non satisfiable constraint");
        }
        assert (this.nbOfWatched() == this.watchingCount);
    }

    private void watchMoreForLearntConstraint() {
        int n = 1;
        while (this.watchCumul - this.coefs[0] < this.degree && n > 0) {
            n = 0;
            int n2 = -1;
            int n3 = -1;
            for (int i = 0; i < this.lits.length; ++i) {
                if (!this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                ++n;
                int n4 = this.voc.getLevel(this.lits[i]);
                if (n4 <= n2) continue;
                n3 = i;
                n2 = n4;
            }
            if (n <= 0) continue;
            assert (n3 >= 0);
            this.voc.watch(this.lits[n3] ^ 1, this);
            this.watching[this.watchingCount++] = n3;
            this.watched[n3] = true;
            this.watchCumul += this.coefs[n3];
            assert (--n >= 0);
        }
        assert (this.lits.length == 1 || this.watchingCount > 1);
    }

    protected void computePropagation(UnitPropagationListener unitPropagationListener) throws ContradictionException {
        for (int i = 0; i < this.lits.length && this.watchCumul - this.coefs[this.watching[i]] < this.degree; ++i) {
            if (!this.voc.isUnassigned(this.lits[i]) || unitPropagationListener.enqueue(this.lits[i], this)) continue;
            throw new ContradictionException("non satisfiable constraint");
        }
    }

    public static MinWatchPbLongCP normalizedMinWatchPbNew(UnitPropagationListener unitPropagationListener, ILits iLits, int[] nArray, BigInteger[] bigIntegerArray, BigInteger bigInteger, BigInteger bigInteger2) throws ContradictionException {
        MinWatchPbLongCP minWatchPbLongCP = new MinWatchPbLongCP(iLits, nArray, bigIntegerArray, bigInteger, bigInteger2);
        if (minWatchPbLongCP.degree <= 0L) {
            return null;
        }
        minWatchPbLongCP.computeWatches();
        minWatchPbLongCP.computePropagation(unitPropagationListener);
        return minWatchPbLongCP;
    }

    protected int nbOfWatched() {
        int n = 0;
        for (int i = 0; i < this.watched.length; ++i) {
            for (int j = 0; j < this.watchingCount; ++j) {
                if (this.watching[j] == i) assert (this.watched[i]);
            }
            n += this.watched[i] ? 1 : 0;
        }
        return n;
    }

    public boolean propagate(UnitPropagationListener unitPropagationListener, int n) {
        int n2;
        assert (this.nbOfWatched() == this.watchingCount);
        assert (this.watchingCount > 1);
        for (n2 = 0; n2 < this.watchingCount && (this.lits[this.watching[n2]] ^ 1) != n; ++n2) {
        }
        int n3 = this.watching[n2];
        assert (n == (this.lits[n3] ^ 1));
        assert (this.watched[n3]);
        long l = this.maximalCoefficient(n3);
        l = this.updateWatched(l, n3);
        long l2 = this.watchCumul - this.coefs[n3];
        assert (this.nbOfWatched() == this.watchingCount);
        if (l2 < this.degree) {
            this.voc.watch(n, this);
            assert (this.watched[n3]);
            assert (!this.isSatisfiable());
            return false;
        }
        if (l2 < this.degree + l) {
            assert (this.watchingCount != 0);
            long l3 = l2 - this.degree;
            for (int i = 0; i < this.watchingCount; ++i) {
                if (l3 >= this.coefs[this.watching[i]] || i == n2 || this.voc.isSatisfied(this.lits[this.watching[i]]) || unitPropagationListener.enqueue(this.lits[this.watching[i]], this)) continue;
                this.voc.watch(n, this);
                assert (!this.isSatisfiable());
                return false;
            }
            this.voc.undos(n).push(this);
        }
        this.watched[n3] = false;
        this.watchCumul = l2;
        this.watching[n2] = this.watching[--this.watchingCount];
        assert (this.watchingCount != 0);
        assert (this.nbOfWatched() == this.watchingCount);
        return true;
    }

    public void remove(UnitPropagationListener unitPropagationListener) {
        for (int i = 0; i < this.watchingCount; ++i) {
            this.voc.watches(this.lits[this.watching[i]] ^ 1).remove(this);
            this.watched[this.watching[i]] = false;
        }
        this.watchingCount = 0;
        assert (this.nbOfWatched() == this.watchingCount);
    }

    public void undo(int n) {
        this.voc.watch(n, this);
        int n2 = 0;
        while ((this.lits[n2] ^ 1) != n) {
            ++n2;
        }
        assert (n2 < this.lits.length);
        this.watchCumul += this.coefs[n2];
        assert (this.watchingCount == this.nbOfWatched());
        this.watched[n2] = true;
        this.watching[this.watchingCount++] = n2;
        assert (this.watchingCount == this.nbOfWatched());
    }

    public static WatchPbLongCP normalizedWatchPbNew(ILits iLits, IDataStructurePB iDataStructurePB) {
        return new MinWatchPbLongCP(iLits, iDataStructurePB);
    }

    protected long maximalCoefficient(int n) {
        long l = 0L;
        for (int i = 0; i < this.watchingCount; ++i) {
            if (this.coefs[this.watching[i]] <= l || this.watching[i] == n) continue;
            l = this.coefs[this.watching[i]];
        }
        assert (this.learnt || l != 0L);
        return l;
    }

    protected long updateWatched(long l, int n) {
        long l2 = l;
        if (this.watchingCount < this.size()) {
            long l3 = this.watchCumul - this.coefs[n];
            long l4 = this.degree + l2;
            for (int i = 0; i < this.lits.length && l3 < l4; ++i) {
                if (this.voc.isFalsified(this.lits[i]) || this.watched[i]) continue;
                l3 += this.coefs[i];
                this.watched[i] = true;
                assert (this.watchingCount < this.size());
                this.watching[this.watchingCount++] = i;
                this.voc.watch(this.lits[i] ^ 1, this);
                if (this.coefs[i] <= l2) continue;
                l2 = this.coefs[i];
                l4 = this.degree + l2;
            }
            this.watchCumul = l3 + this.coefs[n];
        }
        return l2;
    }
}

