/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.ArrayList;
import java.util.List;
import org.sat4j.core.VecInt;
import org.sat4j.minisat.SolverFactory;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.AbstractClauseSelectorSolver;
import org.sat4j.tools.FullClauseSelectorSolver;
import org.sat4j.tools.GroupClauseSelectorSolver;
import org.sat4j.tools.Minimal4InclusionModel;
import org.sat4j.tools.SolutionFoundListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllMUSes {
    private AbstractClauseSelectorSolver<ISolver> css;
    private final List<IVecInt> mssList;
    private final List<IVecInt> secondPhaseClauses;
    private final List<IVecInt> musList;
    private final boolean group;

    public AllMUSes(boolean bl) {
        this.css = !bl ? new FullClauseSelectorSolver<ISolver>(SolverFactory.newDefault(), false) : new GroupClauseSelectorSolver<ISolver>(SolverFactory.newDefault());
        this.mssList = new ArrayList<IVecInt>();
        this.musList = new ArrayList<IVecInt>();
        this.secondPhaseClauses = new ArrayList<IVecInt>();
        this.group = bl;
    }

    public AllMUSes() {
        this(false);
    }

    public <T extends ISolver> T getSolverInstance() {
        return (T)this.css;
    }

    public List<IVecInt> computeAllMUSes() {
        return this.computeAllMUSes(SolutionFoundListener.VOID);
    }

    public List<IVecInt> computeAllMUSes(SolutionFoundListener solutionFoundListener) {
        this.computeAllMSS();
        ISolver iSolver = SolverFactory.newDefault();
        try {
            for (IVecInt object : this.secondPhaseClauses) {
                iSolver.addClause(object);
            }
            Minimal4InclusionModel minimal4InclusionModel = new Minimal4InclusionModel(iSolver, Minimal4InclusionModel.positiveLiterals(iSolver));
            while (minimal4InclusionModel.isSatisfiable()) {
                VecInt vecInt = new VecInt();
                VecInt vecInt2 = new VecInt();
                int[] nArray = minimal4InclusionModel.model();
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] <= 0) continue;
                    vecInt.push(-nArray[i]);
                    vecInt2.push(nArray[i]);
                }
                this.musList.add(vecInt2);
                solutionFoundListener.onSolutionFound(vecInt2);
                minimal4InclusionModel.addBlockingClause(vecInt);
            }
        }
        catch (ContradictionException contradictionException) {
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        System.out.println("MUSes = " + this.musList);
        return this.musList;
    }

    public List<IVecInt> computeAllMSS() {
        return this.computeAllMSS(SolutionFoundListener.VOID);
    }

    public List<IVecInt> computeAllMSS(SolutionFoundListener solutionFoundListener) {
        int n = this.css.nVars();
        VecInt vecInt = new VecInt();
        for (Integer serializable : this.css.getAddedVars()) {
            vecInt.push(serializable);
        }
        Minimal4InclusionModel minimal4InclusionModel = new Minimal4InclusionModel(this.css, vecInt);
        VecInt vecInt2 = new VecInt();
        for (int timeoutException = 0; timeoutException < this.css.getAddedVars().size(); ++timeoutException) {
            vecInt2.push(timeoutException + 1);
        }
        try {
            while (minimal4InclusionModel.isSatisfiable()) {
                int[] contradictionException = minimal4InclusionModel.modelWithInternalVariables();
                VecInt vecInt3 = new VecInt();
                vecInt2.copyTo(vecInt3);
                VecInt vecInt4 = new VecInt();
                VecInt vecInt5 = new VecInt();
                for (int i = 0; i < vecInt.size(); ++i) {
                    int n2 = Math.abs(vecInt.get(i));
                    if (contradictionException[n2 - 1] <= 0) continue;
                    vecInt4.push(-n2);
                    vecInt5.push(n2 - n);
                    vecInt3.remove(n2 - n);
                }
                this.mssList.add(vecInt3);
                solutionFoundListener.onSolutionFound(vecInt3);
                this.secondPhaseClauses.add(vecInt5);
                this.css.addBlockingClause(vecInt4);
            }
        }
        catch (TimeoutException timeoutException) {
            timeoutException.printStackTrace();
        }
        catch (ContradictionException contradictionException) {
            // empty catch block
        }
        System.out.println("MSS = " + this.mssList);
        return this.mssList;
    }
}

