/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;

public class Backbone {
    public static IVecInt compute(ISolver iSolver) throws TimeoutException {
        return Backbone.compute(iSolver, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver iSolver, IVecInt iVecInt) throws TimeoutException {
        boolean bl = iSolver.isSatisfiable(iVecInt);
        if (!bl) {
            return VecInt.EMPTY;
        }
        return Backbone.compute(iSolver, iSolver.primeImplicant(), iVecInt);
    }

    public static IVecInt compute(ISolver iSolver, int[] nArray) throws TimeoutException {
        return Backbone.compute(iSolver, nArray, VecInt.EMPTY);
    }

    public static IVecInt compute(ISolver iSolver, int[] nArray, IVecInt iVecInt) throws TimeoutException {
        VecInt vecInt = new VecInt();
        for (int n : nArray) {
            if (iVecInt.contains(n)) continue;
            vecInt.push(-n);
        }
        Object object = new VecInt();
        iVecInt.copyTo((IVecInt)object);
        while (!vecInt.isEmpty()) {
            int n = vecInt.last();
            object.push(n);
            vecInt.pop();
            if (iSolver.isSatisfiable((IVecInt)object)) {
                object.pop();
                nArray = iSolver.primeImplicant();
                Backbone.removeVarNotPresentAndSatisfiedLits(nArray, vecInt, iSolver.nVars());
                continue;
            }
            object.pop().push(-n);
        }
        return object;
    }

    private static void removeVarNotPresentAndSatisfiedLits(int[] nArray, IVecInt iVecInt, int n) {
        int n2;
        int[] nArray2 = new int[n + 1];
        int[] nArray3 = nArray;
        int n3 = nArray3.length;
        for (n2 = 0; n2 < n3; ++n2) {
            int n4;
            nArray2[(n4 = nArray3[n2]) > 0 ? n4 : -n4] = n4;
        }
        n2 = 0;
        while (n2 < iVecInt.size()) {
            int n5 = iVecInt.get(n2);
            n3 = nArray2[n5 > 0 ? n5 : -n5];
            if (n3 == 0 || n3 == n5) {
                iVecInt.delete(n2);
                continue;
            }
            ++n2;
        }
    }
}

