/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.tools.AbstractClauseSelectorSolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FullClauseSelectorSolver<T extends ISolver>
extends AbstractClauseSelectorSolver<T> {
    private static final long serialVersionUID = 1L;
    protected Map<Integer, IConstr> constrs = new HashMap<Integer, IConstr>();
    protected final IVecInt lastClause = new VecInt();
    protected IConstr lastConstr;
    protected final boolean skipDuplicatedEntries;

    public FullClauseSelectorSolver(T t, boolean bl) {
        super(t);
        this.skipDuplicatedEntries = bl;
    }

    public IConstr addControlableClause(IVecInt iVecInt) throws ContradictionException {
        if (this.skipDuplicatedEntries) {
            if (iVecInt.equals(this.lastClause)) {
                return null;
            }
            this.lastClause.clear();
            iVecInt.copyTo(this.lastClause);
        }
        int n = this.createNewVar(iVecInt);
        iVecInt.push(n);
        this.lastConstr = super.addClause(iVecInt);
        if (this.lastConstr == null) {
            this.discardLastestVar();
        } else {
            this.constrs.put(n, this.lastConstr);
        }
        return this.lastConstr;
    }

    public IConstr addNonControlableClause(IVecInt iVecInt) throws ContradictionException {
        return super.addClause(iVecInt);
    }

    @Override
    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        return this.addControlableClause(iVecInt);
    }

    @Override
    public int[] model() {
        int[] nArray = super.modelWithInternalVariables();
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = new int[nArray.length - this.constrs.size()];
        int n = 0;
        for (int n2 : nArray) {
            if (this.constrs.get(Math.abs(n2)) != null) continue;
            nArray2[n++] = n2;
        }
        return nArray2;
    }

    public Collection<IConstr> getConstraints() {
        return this.constrs.values();
    }

    @Override
    public Collection<Integer> getAddedVars() {
        return this.constrs.keySet();
    }
}

