/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.tools;

import org.sat4j.core.VecInt;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.ISolver;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.TimeoutException;
import org.sat4j.tools.SolutionFoundListener;
import org.sat4j.tools.SolverDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Minimal4InclusionModel
extends SolverDecorator<ISolver> {
    private static final long serialVersionUID = 1L;
    private final IVecInt pLiterals;
    private int[] prevfullmodel;
    private final SolutionFoundListener modelListener;

    public Minimal4InclusionModel(ISolver iSolver, IVecInt iVecInt, SolutionFoundListener solutionFoundListener) {
        super(iSolver);
        this.pLiterals = new VecInt(iVecInt.size());
        iVecInt.copyTo(this.pLiterals);
        this.modelListener = solutionFoundListener;
    }

    public Minimal4InclusionModel(ISolver iSolver, IVecInt iVecInt) {
        this(iSolver, iVecInt, SolutionFoundListener.VOID);
    }

    public Minimal4InclusionModel(ISolver iSolver) {
        this(iSolver, Minimal4InclusionModel.negativeLiterals(iSolver), SolutionFoundListener.VOID);
    }

    public static IVecInt positiveLiterals(ISolver iSolver) {
        VecInt vecInt = new VecInt(iSolver.nVars());
        for (int i = 1; i <= iSolver.nVars(); ++i) {
            vecInt.push(i);
        }
        return vecInt;
    }

    public static IVecInt negativeLiterals(ISolver iSolver) {
        VecInt vecInt = new VecInt(iSolver.nVars());
        for (int i = 1; i <= iSolver.nVars(); ++i) {
            vecInt.push(-i);
        }
        return vecInt;
    }

    @Override
    public int[] model() {
        int[] nArray = null;
        VecInt vecInt = new VecInt();
        VecInt vecInt2 = new VecInt();
        try {
            do {
                this.prevfullmodel = super.modelWithInternalVariables();
                nArray = super.model();
                this.modelListener.onSolutionFound(nArray);
                vecInt.clear();
                vecInt2.clear();
                for (int n : this.prevfullmodel) {
                    if (this.pLiterals.contains(n)) {
                        vecInt.push(-n);
                        continue;
                    }
                    vecInt2.push(n);
                }
                this.addBlockingClause(vecInt);
            } while (this.isSatisfiable(vecInt2));
        }
        catch (TimeoutException timeoutException) {
            throw new IllegalStateException("Solver timed out");
        }
        catch (ContradictionException contradictionException) {
            // empty catch block
        }
        return nArray;
    }

    @Override
    public int[] modelWithInternalVariables() {
        this.model();
        return this.prevfullmodel;
    }
}

